
package circusRefine.core.storage;

import circusRefine.core.ExternalManager;
import circusRefine.util.OPTipos;

/**
 * Passo de execuo, efetuado pelo usuario quando o mesmo
 * mudar o valor de uma Op baseado numa prova manual
 * @author Usuario
 *
 */
public class SetandoStatusOp implements StepOfExecution{
	/**
	 * Valor obtido pela prova manual
	 */
	private OPTipos tipoSetadoAnterior;
	private OPTipos tipoSetadoPosterior;
	/**
	 * Indice da OP correspondente
	 */
	private int indiceOP;
	
	

	public SetandoStatusOp(OPTipos tipoSetadoAnterior,
			OPTipos tipoSetadoPosterior, int indiceOP) {
		super();
		this.tipoSetadoAnterior = tipoSetadoAnterior;
		this.tipoSetadoPosterior = tipoSetadoPosterior;
		this.indiceOP = indiceOP;
	}

	public void doStep(ExternalManager externo) {
		externo.retornarTelaObrigacao().setarValorOP(tipoSetadoPosterior, indiceOP, true);
		
	}

	public void redoStep(ExternalManager externo) {
		externo.retornarTelaObrigacao().setarValorOP(tipoSetadoPosterior, indiceOP, false);
	}

	public void undoStep(ExternalManager externo) {
		externo.retornarTelaObrigacao().setarValorOP(tipoSetadoAnterior, indiceOP, false);
	}


	public int getIndiceOP() {
		return indiceOP;
	}

	public OPTipos getTipoSetadoAnterior() {
		return tipoSetadoAnterior;
	}

	public OPTipos getTipoSetadoPosterior() {
		return tipoSetadoPosterior;
	}

	/**
	 * Nao realizam funcao alguma na impressao de saida do docgenerator
	 */
	public void redoPrintLatexStep(ExternalManager externo) {
		
	}

	/**
	 * Nao realizam funcao alguma na impressao de saida do docgenerator
	 */
	public void undoPrintLatexStep(ExternalManager externo) {
		
	}

}
