package circusRefine.core.storage;

import javax.swing.JOptionPane;

import circusRefine.core.ExternalManager;

/**
 * Considero que sempre so havera duas formas de impressao
 * de OPs : Extendida e Resumida. Assim sempre que houver
 * esse passo ha uma mudanca nesse formato de impressao. Logo
 * necessita-se apenas do indice que ocorreu essa mudanca.
 * @author Usuario
 *
 */
public class SetandoFormaOP implements StepOfExecution {

	private int indiceOP;

	public SetandoFormaOP(int indiceOP) {
		super();
		this.indiceOP = indiceOP;
	}

	public void doStep(ExternalManager externo) {
		externo.mudarFormatoImpressaoOP(indiceOP, true);
	}

	public void redoStep(ExternalManager externo) {
		externo.mudarFormatoImpressaoOP(indiceOP, false);
	}

	public void undoStep(ExternalManager externo) {
		externo.mudarFormatoImpressaoOP(indiceOP, false);
	}

	public int getIndiceOP() {
		return indiceOP;
	}

	/**
	 * Nao realizam funcao alguma na impressao de saida do docgenerator
	 */
	public void redoPrintLatexStep(ExternalManager externo) {
		
	}

	/**
	 * Nao realizam funcao alguma na impressao de saida do docgenerator
	 */
	public void undoPrintLatexStep(ExternalManager externo) {
		
	}
}
