/*
 * Projeto: Circus Refine
 */
package circusRefine.core.storage;

import com.thoughtworks.xstream.annotations.XStreamAsAttribute;

import circusRefine.core.ExternalManager;

/**
 * Classe que representa a ao de remoo de um comentrio do 
 * refinamento
 * 
 * @author Cristiano Castro
 */
public class RemocaoComentario implements StepOfExecution {

	/** Nmero para a serializao */
	private static final long serialVersionUID = -8437927152502757151L;

	/** Linha inicial no qual o comentrio foi adicionado */
	@XStreamAsAttribute
	private int linhaInicial;
	
	/** Linha Final no qual o comentrio foi adicionado */
	@XStreamAsAttribute
	private int linhaFinal;
	
	/** Identificador do Comentario Removido */
	private int identificador;
	/**
	 * Inicia o passo de remoo de comentrio.
	 * 
	 * @param linhaInicial a linha inicial no qual o comentrio foi
	 *  removido
	 * @param linhaFinal a linha final no qual o comentrio foi 
	 *  removido
	 */
	public RemocaoComentario(int linhaInicial, int linhaFinal, int idt) {
		this.setLinhaInicial(linhaInicial);
		this.setLinhaFinal(linhaFinal);
		this.setIdentificador(idt);
	}

	/**
	 * @return the linhaInicial
	 */
	public int getLinhaInicial() {
		return linhaInicial;
	}

	/**
	 * @param linhaInicial the linhaInicial to set
	 */
	public void setLinhaInicial(int linhaInicial) {
		this.linhaInicial = linhaInicial;
	}

	/**
	 * @return the linhaFinal
	 */
	public int getLinhaFinal() {
		return linhaFinal;
	}

	/**
	 * @param linhaFinal the linhaFinal to set
	 */
	public void setLinhaFinal(int linhaFinal) {
		this.linhaFinal = linhaFinal;
	}

	/**
	 * Remove um comentrio da ferramenta
	 * 
	 * @param externo o gerenciador externo do CRefine
	 */
	public void doStep(ExternalManager externo) {
		externo.removeComment(this.getLinhaInicial(), this.getLinhaFinal());
	}

	public void undoStep(ExternalManager externo) {
		externo.desfazerRemocaoComentario();

	}
	
	public int getIdentificador() {
		return identificador;
	}

	public void setIdentificador(int identificador) {
		this.identificador = identificador;
	}

	public void redoStep(ExternalManager externo) {
		externo.refazerRemocaoComentario();
	}

	/**
	 * Nao realizam funcao alguma na impressao de saida do docgenerator
	 */
	public void redoPrintLatexStep(ExternalManager externo) {
		
	}

	/**
	 * Nao realizam funcao alguma na impressao de saida do docgenerator
	 */
	public void undoPrintLatexStep(ExternalManager externo) {
		
	}

}
