/*
 * Projeto: Circus Refine
 */
package circusRefine.core.storage;

import circusRefine.util.CRefineException;

/**
 * Exceo disparada por algum erro na abertura de um arquivo
 * 
 * @author Cristiano Castro
 */
public class OpenSpecificationException extends CRefineException {

	private static final String MESSAGE_FOR_THE_USER_CODE = "COD0262";
	
	/**
	 * Nmero para a serializao
	 */
	private static final long serialVersionUID = -3236665119456536860L;

	/**
	 * Cria uma exceo de Abertura de arquivo
	 */
	public OpenSpecificationException() {
		super( OpenSpecificationException.MESSAGE_FOR_THE_USER_CODE );
	}

	/**
	 * 
	 * @param message
	 * @param cause
	 */
	public OpenSpecificationException(String message, Throwable cause) {
		super( message, cause , 
				OpenSpecificationException.MESSAGE_FOR_THE_USER_CODE );
	}

	/**
	 * @param message
	 */
	public OpenSpecificationException(String message) {
		super( message , OpenSpecificationException.MESSAGE_FOR_THE_USER_CODE);
	}

	/**
	 * @param cause
	 */
	public OpenSpecificationException(Throwable cause) {
		super( cause , OpenSpecificationException.MESSAGE_FOR_THE_USER_CODE );
	}

	

}
