package circusRefine.core.storage;

import circusRefine.core.ExternalManager;
import circusRefine.core.crules.CRulesException;
import circusRefine.core.specificationeditor.SpecificationEditorException;
import circusRefine.util.CRefineException;

/**
 * Classe que representa a execucao de insercao
 * de um paragrafo no programa.
 * @author Alessandro
 *
 */
public class InsertParagraph implements StepOfExecution {

	/** Nmero para a serializao */
	private static final long serialVersionUID = 2624784789459805169L;

	/** Texto do pargrafo inserido */
	private String text;

	public InsertParagraph(String text) {
		this.text = text;
	}

	/** 
	 * Executa o passo de insero de pargrafo na tela do CRefine
	 * 
	 * @param externo
	 */
	public void doStep(ExternalManager externo) throws CRefineException,
	CRulesException{
		externo.parsingParagraphAndDisplay(text);
		InsertParagraph passo = new InsertParagraph(text);
		externo.inserirPassoHistorico(passo);

	}

	/**
	 * 
	 */
	public void redoPrintLatexStep(ExternalManager externo) {

	}

	public void redoStep(ExternalManager externo) {
		try {
			externo.parsingParagraphAndDisplay(text);
		} catch (CRefineException e) {
			e.printStackTrace();
		}
		catch (CRulesException e){

		}
	}

	public void undoPrintLatexStep(ExternalManager externo) {

	}

	public void undoStep(ExternalManager externo) throws SpecificationEditorException, CRulesException {
		externo.desfazerInsertedParagraph(text);
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

}
