/*
 * Projeto: Circus Refine
 */
package circusRefine.core.storage;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;

import circusRefine.core.ExternalManager;
import circusRefine.util.CRefineException;
import net.sourceforge.czt.session.Markup;
import net.sourceforge.czt.session.StringSource;

/**
 * Classe usada para especificar o carregamento de um programa no Circus Refine
 * 
 * @author Cristiano Castro
 */
@XStreamAlias("Load")
public class CarregamentoEspecificacao implements StepOfExecution {

	/**
	 * Nmero da serializao
	 */
	private static final long serialVersionUID = -853304208070015877L;

	/** Especificao carregada */
	private String especificacao;
	
	/** Markup no qual a especificao foi carregada */
	@XStreamAsAttribute
	private Markup markupInicial;
	
	private String nome = "source";

	/**
	 * Construtor incial o programa com a especificao original.
	 * 
	 * @param especificacao a string com a especificao carregada
	 * @param incial markup com o qual o programa foi carregado
	 */
	public CarregamentoEspecificacao(String especificacao, Markup inicial) {
		this.setEspecificacao(especificacao);
		this.setMarkupInicial(inicial);
	}

	public String getEspecificacao() {
		return especificacao;
	}
	
	public void setNome(String name){
		nome = name;
	}
	public String getNome() {
		return nome;
	}

	public void setEspecificacao(String especificacao) {
		this.especificacao = especificacao;
	}

	public Markup getMarkupInicial() {
		return markupInicial;
	}
	
	public void setMarkupInicial(Markup markupInicial) {
		this.markupInicial = markupInicial;
	}

	public void doStep(ExternalManager externo) throws CRefineException {
		Markup temp = this.getMarkupInicial();
		externo.retornarTelaPrincipal().setarMarkUp(temp);
		StringSource source = new StringSource(this.getEspecificacao());
		externo.openSpecification(source, nome);
		
	}
	
	
	public void undoStep(ExternalManager externo) {
		/* Nesse caso no h redo !!! */
	}

	public void redoStep(ExternalManager externo) {
		
	}

	/**
	 * Nao realizam funcao alguma na impressao de saida do docgenerator
	 */
	public void redoPrintLatexStep(ExternalManager externo) {
		
	}

	/**
	 * Nao realizam funcao alguma na impressao de saida do docgenerator
	 */
	public void undoPrintLatexStep(ExternalManager externo) {
		
	}
	
}
