/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.specificationeditor;

import circusRefine.util.CRefineException;

/**
 * Erro disparado quando algum erro de especificao ocorre
 * 
 * @author Cristiano Castro
 */
public class SpecificationEditorException extends CRefineException {
	
	protected static final String MESSAGE_TO_THE_USER_CODE = "COD0628" ;

	/** Nmero para serializao */
	private static final long serialVersionUID = -4648567315810873768L;

	/**
	 * @param msg
	 * @param cod
	 */
	public SpecificationEditorException( String msg ) {
		super( msg , SpecificationEditorException.MESSAGE_TO_THE_USER_CODE );
	}

	/**
	 * @param msg
	 * @param arg1
	 * @param cod
	 */
	public SpecificationEditorException( String msg , Throwable arg1 ) 
	{
		super( msg , arg1 , 
				SpecificationEditorException.MESSAGE_TO_THE_USER_CODE );
	}

	/**
	 * @param cod
	 */
	public SpecificationEditorException() {
		super( SpecificationEditorException.MESSAGE_TO_THE_USER_CODE );
	}

	/**
	 * @param arg0
	 * @param cod
	 */
	public SpecificationEditorException(Throwable arg0) {
		super( arg0 , SpecificationEditorException.MESSAGE_TO_THE_USER_CODE );
	}

}
