/*
 * Projeto: Circus Refine
 */
package circusRefine.core.relations;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.base.visitor.VisitorUtils;

/**
 * Visitor utilizado para remover a pilha de relacionamentos de um
 * {@link Term}, caso esta exista.
 * 
 * @author Cristiano Gurgel
 */
public class StackRemoveVisitor implements TermVisitor<Void> {

	/** Construtor padro */
	public StackRemoveVisitor() { }
	
	/**
	 * Remove a pilha de relacionamentos de uma AST.
	 * 
	 * @param termo o termo a ser visitado
	 * @return <code>null</code>.
	 * @throws NullPointerException caso termo seja 
	 * 		<code>null</code>.
	 */
	public Void visitTerm(Term termo) {
		int cont = -1;
		int i = 0;
		for (Object ann : termo.getAnns()) {
			if (ann instanceof RelationsAnnStack) {
				cont = i;
			}
			i++;
		}
		
		if (cont != -1) {
			termo.getAnns().remove(cont);
		}
		
		/* Remove a pilha de relacionamento dos filhos */
		VisitorUtils.visitTerm(this, termo);
		return null;
	}

}
