/*
 * Projeto: Circus Refine
 */
package circusRefine.core.relations;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;

/**
 * Visitor para retornar pilha de relacionamentos de um termo.
 * 
 * @author Cristiano Gurgel
 */
public class RelationsAnnStackGetter implements TermVisitor<RelationsAnnStack> {

	
	public RelationsAnnStackGetter() { }
	
	/**
	 * Visita um termo retornando a sua pilha de relacionamentos.
	 * Caso esta no exista, a pilha  inserida no termo.
	 * 
	 * @param termo o termo a ser visitado
	 */
	public RelationsAnnStack visitTerm(Term termo) {
		
		//System.out.println("#1 Tamanho das anotaes de " + termo + " : " 
		//			+ termo.getAnns().size());
		for (Object ann : termo.getAnns()) {
			if (ann instanceof RelationsAnnStack) {

				//System.out.println("Achei a pilha do termo acima!");
				/* Termo possui o atributo da pilha */
				return (RelationsAnnStack)ann;
			}
		}
		
		/* Termo no possui o atributo da pilha */
		RelationsAnnStack nova = new RelationsAnnStack();
		boolean add = termo.getAnns().add(nova);
		//System.out.println(add + " #2 Tamanho das anotaes de " + termo + " : " 
		//		+ termo.getAnns().size());
		return nova;
		//InitVisitor.initAST(termo);
		//return this.visitTerm(termo);
	}

}
