package circusRefine.core.relations;

import circusRefine.util.CRefineAnnotation;

/**
 * Classe utilizada para ser armazenada nos termos da AST guardando as informaes
 * das linhas iniciais e finais onde esses termos sao exibidos na tela
 * @author Alessandro
 */

public class RelationsAnn implements CRefineAnnotation {
	
	
	private int linha_inicial;
	private int linha_final;
	
	public RelationsAnn () {
		linha_inicial = 0;
		linha_final = 0;
	}
	public RelationsAnn (int x, int y) {
		linha_inicial = x;
		linha_final = y;
	}
	public void setLinhaInicial (int x){
		linha_inicial = x;
	}
	public void setLinhaFinal(int x){
		linha_final = x;
	}
	public int getLinhaInicial(){
		return linha_inicial;
	}
	public int getLinhaFinal(){
		return linha_final;
	}
	public void addLinhaInicial(int x){
		linha_inicial+= x;
	}
	public void addLinhaFinal(int x){
		linha_final+= x;
	}
	/**
	 * Metodo utilizada para aumentar os campos linhas,  utilizado
	 * na atualizao da arvore dado uma coleo de ao ou aplicao de lei
	 * @param x valor a ser adicionado nos campos linhas
	 */
	public void addLinhas(int x){
		linha_inicial+= x;
		linha_final+= x;
	}
	
	
	
	public void subLinhaInicial(int x){
		linha_inicial-= x;
	}
	public void subLinhaFinal(int x){
		linha_final-= x;
	}
	/**
	 * Metodo utilizada para diminuir os campos linhas,  utilizado
	 * na atualizao da arvore dado um undo
	 * @param x valor a ser diminuido nos campos linhas
	 */
	public void subLinhas(int x){
		linha_inicial-= x;
		linha_final-= x;
	}
	
	
}
