package circusRefine.core.relations;

import java.util.List;

import circusRefine.core.util.ChildrenTermExtractor;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
/**
 * Classe utilizada para Reincorpora alguns relacionamentos que estavam guarda
 * a RedoPilha e que agora serao colocados ao Topo da Pilha Original
 * @author Alessandro
 *
 */

public class RefazerRelationsVisitor implements TermVisitor<Void> {

	public Void visitTerm(Term termo) {
		if (!RelationsUtils.retornaPilhaRedo(termo).isEmpty()){
			RelationsUtils.retornaPilha(termo).push(RelationsUtils.retornaPilhaRedo(termo).pop());
		}
		
		/*  importante lembrar que os filhos tb devem ter seus campos
		 * atualizados
		 */
		ChildrenTermExtractor extrator = new ChildrenTermExtractor();
		List<Term> filhos = termo.accept(extrator);

		for (Term filho : filhos) {
			filho.accept(this);
		}
		
		return null;
	}

}
