package circusRefine.core.relations;

import java.util.List;

import circusRefine.core.util.ChildrenTermExtractor;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
/**
 * Bem, essa classe foi criado com o objetivo de desfazer as atualizao que
 * foram prontamente adicionados e que se encontram no topo da pilha de rela
 * es, dessa forma, a removamos e a inserimos na RedoPilha de relacionamentos 
 * @author Alessandro
 *
 */


public class DesfazerRelationsVisitor implements TermVisitor<Void>{

	/**
	 * Metodo que remove o antigo relacionamentos e insere na RedoPilha
	 */
	public Void visitTerm(Term termo) {
		/*Verifica se h pilha de relacionamento no termo*/
		if (!RelationsUtils.retornaPilha(termo).isEmpty()) {
			RelationsUtils.retornaPilhaRedo(termo).push(RelationsUtils.retornaPilha(termo).pop());
		}
		/*  importante lembrar que os filhos tb devem ter seus campos
		 * atualizados
		 */
		ChildrenTermExtractor extrator = new ChildrenTermExtractor();
		List<Term> filhos = termo.accept(extrator);

		for (Term filho : filhos) {
			filho.accept(this);
		}
		
		return null;
	}
	

}
