/*
 * ProgramPrint.java
 *
 * Created on 20 de Setembro de 2005, 17:53
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package circusRefine.core.print;

import circusRefine.core.NoPrograma;
import circusRefine.core.Relacionamento;
import circusRefine.core.relations.RelationsAnn;
import circusRefine.core.relations.RelationsUtils;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JOptionPane;

import net.sourceforge.czt.base.ast.*;
import net.sourceforge.czt.z.ast.*;
import net.sourceforge.czt.z.impl.ZParaListImpl;
import net.sourceforge.czt.z.visitor.*;
import net.sourceforge.czt.base.util.*;
import net.sourceforge.czt.base.visitor.*;
import net.sourceforge.czt.circus.ast.Action2;
import net.sourceforge.czt.circus.ast.ChannelSetPara;
import net.sourceforge.czt.circus.ast.OnTheFlyDefAnn;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.circus.ast.TransformerPara;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circus.visitor.Action2Visitor;

/**
 *
 * @author comp
 */
public class ProgramPrint 
  extends Print 
  implements SpecVisitor,
             ZSectVisitor,
             ParentVisitor,
             SectVisitor ,
             NarrSectVisitor{
  
  /** Creates a new instance of ProgramPrint */
  public ProgramPrint(Printer printer) {
    super(printer);
  }

  public Object visitSpec(Spec spec)
  {
	  getPercurso().append("Spec in ProgramPrint\n");
	  int adder = 1;
	  String[] result = null;

	  List<Sect> sects = spec.getSect();
	  
	  for (Sect sect : sects) {
		  getPercurso().append("Chamando Program Print");
		  result = (String[])sect.accept(programPrint());
	  }
	  
	  NoPrograma noProg = new NoPrograma(spec);
	  int length = result.length;
	  Relacionamento rel = new Relacionamento(0, length -2, noProg);
	  this.addCounterRow(length + adder);
	  
	  RelationsUtils.insertRelation(new RelationsAnn(0,length -2)
	  , spec, isToInsertingRelAnn());
	  
	  addRelacionamento(rel);
	  
	  return result;
  }

  /**
   * Any "left over" sections.
   */
  public Object visitSect(Sect sect)
  {
    getPercurso().append("SECT\n");
    
    ZSect zsect = (ZSect)sect;
    
    String[] result = (String[])zsect.accept(programPrint());
    
    return result;
  }

  public Object visitZSect(ZSect zSect)
  {
	  getPercurso().append("ZSect\n");
	  String[] result = new String[0];
	  
	  //Guarda-se o termo ZSect para que as referencias
	  // as implicits processes sejam guardada
	  this.setCurrentZSection(zSect);
	  
	  ZParaList paras= zSect.getZParaList();

	  for (Para para : paras) {
		  getPercurso().append("Chamando o ParaPrint\n");
		  
		  String[] strPara = null;

		  if (!(para instanceof LatexMarkupPara || para instanceof NarrPara || this.isImplicitPara(para))) {
			  strPara = (String[])para.accept(paraPrint());
			  
			  //Isso aki � um arrumadinho para ajeitar os relacionamentos de Schemas
			  //definidos fora de um processo. 
			  //Como nao se tem essa informacao explicitamente num termo de processo
			  //O metodo AxPara eh por default configurado para dentro de um processo
			  // E quanto o mesmo visitor eh chamado fora de um processo, deve-se fazer
			  //essa modifica��o
			  if (para instanceof AxPara || para instanceof TransformerPara || para instanceof ChannelSetPara){
				  this.setCounterRow(this.getCounterRow() + 1);
			  }
			  String[] strParaTemp = new String[result.length + strPara.length + 1];
			  int index = 0;
			  for(int i=0; i<result.length; i++) {
				  strParaTemp[index++] = result[i];
			  }
			  for(int i=0; i<strPara.length; i++) {
				  strParaTemp[index++] = strPara[i];
			  }
			  strParaTemp[index] = "";
			  result = strParaTemp;

		  }
		  else {
			  String[] strParaTemp = new String[result.length];
			  int index = 0;
			  for(int i=0; i<result.length; i++) {
				  strParaTemp[index++] = result[i];
			  }
			  result = strParaTemp;
		  }
	  }
	  return result;
  }
 
 public Object visitNarrSect (NarrSect narrSect) {
	 getPercurso().append("NarrSect\n");
	 //foi decidido nao entraria no desenvolvimento
	 return null;
 }

  public Object visitParent(Parent parent)
  {
	  //TODO entender o q eh e desenvolver =D!
	  String [] result = new String[1];
	  result[0] = parent.getWord();
	  
    return result;
  }
  /**
   * Metodo que verifica se o paragrafo em questao � um implicite process
   * @param p para a ser verificado
   * @return true se o mesmo for um processo implicito
   */
  public boolean isImplicitPara (Para p) {
	  boolean result = false;
	  if ( ( p instanceof ProcessPara ) && ((ProcessPara)p).getZName().getWord().startsWith(CircusUtils.DEFAULT_IMPLICIT_PROCESS_NAME_PREFIX)){
		  result = true;
	  }
	  return result;
  }


  
}
