
package circusRefine.core.print;
/**
 * Classe que trata os visitor referentes a parte Process2 da Circus AST
 * @author Alessandro
 */


import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.circus.util.CircusString;
import net.sourceforge.czt.circus.ast.ExtChoiceProcess;
import net.sourceforge.czt.circus.ast.IntChoiceProcess;
import net.sourceforge.czt.circus.ast.InterleaveProcess;
import net.sourceforge.czt.circus.ast.ParProcess;
import net.sourceforge.czt.circus.ast.SeqProcess;
import net.sourceforge.czt.circus.visitor.ExtChoiceProcessVisitor;
import net.sourceforge.czt.circus.visitor.IntChoiceProcessVisitor;
import net.sourceforge.czt.circus.visitor.InterleaveProcessVisitor;
import net.sourceforge.czt.circus.visitor.ParProcessVisitor;
import net.sourceforge.czt.circus.visitor.SeqProcessVisitor;

public class Process2Print 
extends Print 
implements 
ExtChoiceProcessVisitor,
IntChoiceProcessVisitor,
SeqProcessVisitor ,
ParProcessVisitor 
{
	/** Creates a new instance of ActionPrint */
	public Process2Print(Printer printer) {
		super(printer);
	}

//	Process ::= Process \extchoice Process
	public Object visitExtChoiceProcess(ExtChoiceProcess term) {
		String[] result = new String[1];

		if (!getUnicoded()) {
			result[0] = "\\extchoice";
		}
		else{
			result[0] = CircusString.EXTCHOICE;
		}
		return result;
	}

	// Process ::= Process \intchoice Process
	public Object visitIntChoiceProcess(IntChoiceProcess term) {
		String[] result = new String[1];

		if (!getUnicoded()) {
			result[0] = "\\intchoice";
		}
		else{
			result[0] = CircusString.INTCHOICE;
		}
		return result;
	}
//	Process ::= Process ; Process
	public Object visitSeqProcess(SeqProcess term) {
		String[] result = new String[1];

		if (!getUnicoded()) {
			result[0] = "\\circseq";
		}
		else{
			result[0] = CircusString.CIRCSEQ;
		}
		return result;	
	}

	/**
	 * Esse metodo apenas redimensiona o termo para o visitor correto
	 */
	public Object visitParProcess(ParProcess term) {
		return term.accept(ParProcessPrint());
	}

}
