/*
 * Printer.java
 *
 * Created on 12 de Setembro de 2005, 19:55
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package circusRefine.core.print;

import java.util.ArrayList;
import java.util.List;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.ChannelSet;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.impl.VarDeclCommandImpl;
import net.sourceforge.czt.session.Markup;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.NameList;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.SchText;
import net.sourceforge.czt.z.ast.Spec;
import net.sourceforge.czt.z.ast.ZSect;
import net.sourceforge.czt.z.impl.VarDeclImpl;
import net.sourceforge.czt.z.util.ZString;
import circusRefine.core.Pair;
import circusRefine.core.Relacionamento;
import circusRefine.core.util.Text;

/**
 *
 * @author Alessandro
 */
public class Printer {
    
	/**
	 * 
	 * @param term
	 * @param marca
	 * @param insertRelations boolean se determina se havera ou nao
	 * insercao de relacionamentos nos nodos percorridos
	 * @return
	 */
    public static String[] print (Term term, Markup marca, boolean insertRelations) {
    	Printer printer = new Printer(marca, insertRelations);
    	printer.inserirRelsAnn = insertRelations;
		String[] strProg = (String[])printer.visitTerm(term);
		//System.out.println(printer.getPercurso());
		return strProg;
    }
    
    /**
     * Recupera o termo impresso como uma String e não como um vetor.
     * 
     * @param termo o termo a ser impresso
     * @param marca o tipo da impressão desejada
     * @param insertRelations boolean se determina se havera ou nao
	 * insercao de relacionamentos nos nodos percorridos
     * @return a {@link String} representado o programa
     */
    public static String printAll(Term termo, Markup marca, boolean insertR) {
    	String[] vetor = Printer.print(termo, marca, insertR);
    	StringBuilder result = new StringBuilder();
    	for (int i = 0 ; i < vetor.length ; i++) {
    		result.append(vetor[i]);
    		
    		if (i != vetor.length - 1) {
    			
    			/* Não é o último elemento do vetor */
    			result.append('\n');
    		}
    	}
    	return result.toString();
    }
    
    protected Print actionPrint_;
    protected Print actionItePrint_;
    protected Print communPrint_;
    protected Print commandPrint_;
    protected Print exprPrint_;
    protected Print predPrint_;
    protected Print declPrint_;
    protected Print declListPrint_;
    protected Print processPrint_;
    protected Print process2Print_;
    protected Print processItePrint_;
    protected Print parProcessPrint_;
    protected Print paraPrint_;
    protected Print paraListPrint_;
    protected Print programPrint_;
    protected Print action2Print_;
    protected Print parActionPrint_;
    protected Print exprListPrint_;
    protected Print namePrint_;
    protected Print nameListPrint_;
    protected Print operPrint_;
    protected Print varDecl_;
    
    protected StringBuilder percurso;
    
    protected Text tipo;
    
    
    protected List<Relacionamento> relacionamentos_;
    /*Contador de Linhas -> para Relacionamentos*/
        
    protected int counterRow; 
    protected boolean isSchema_;
    
    protected ZSect currentZSect ;
    
    protected  Markup markUp;
   
    protected List<Pair> pairs_;
    
    /* Atributo Estatico que determinar se o printer devera ou nao
     * inserir relacionamentos na arvore*/
    protected boolean inserirRelsAnn;


    /** Creates a new instance of Printer */
    public Printer(Markup markUP, boolean toInsert) {
      this.actionPrint_ = new ActionPrint(this);
      this.action2Print_ = new Action2Print(this);
      this.actionItePrint_ = new ActionItePrint(this);
      this.parActionPrint_ = new ParActionPrint(this);
      this.communPrint_ = new CommunPrint(this);
      this.commandPrint_ = new CommandPrint(this);
      this.exprPrint_ = new ExprPrint(this);
      this.exprListPrint_ = new ExprListPrint(this);
      this.predPrint_ = new PredPrint(this);
      this.declPrint_ = new DeclPrint(this);
      this.declListPrint_ = new DeclListPrint(this);
      this.namePrint_ = new NamePrint(this);
      this.nameListPrint_ = new NameListPrint(this);
      this.processPrint_ = new ProcessPrint(this);
      this.process2Print_ = new Process2Print(this);
      this.processItePrint_ = new ProcessItePrint(this);
      this.parProcessPrint_ = new ParProcessPrint(this);
      this.paraPrint_ = new ParaPrint(this);
      this.paraListPrint_	= new ParaListPrint(this);
      this.programPrint_ = new ProgramPrint(this);
      this.operPrint_ = new OperPrint(this);
      this.relacionamentos_ = new ArrayList<Relacionamento>();
      this.isSchema_ = false;
      this.counterRow = 0;
      this.markUp = markUP;
      this.percurso = new StringBuilder();
      
      this.inserirRelsAnn = toInsert;
    }
    
    public Printer() {
        this.actionPrint_ = new ActionPrint(this);
        this.action2Print_ = new Action2Print(this);
        this.actionItePrint_ = new ActionItePrint(this);
        this.parActionPrint_ = new ParActionPrint(this);
        this.communPrint_ = new CommunPrint(this);
        this.commandPrint_ = new CommandPrint(this);
        this.exprPrint_ = new ExprPrint(this);
        this.exprListPrint_ = new ExprListPrint(this);
        this.predPrint_ = new PredPrint(this);
        this.declPrint_ = new DeclPrint(this);
        this.declListPrint_ = new DeclListPrint(this);
        this.namePrint_ = new NamePrint(this);
        this.nameListPrint_ = new NameListPrint(this);
        this.processPrint_ = new ProcessPrint(this);
        this.process2Print_ = new Process2Print(this);
        this.processItePrint_ = new ProcessItePrint(this);
        this.parProcessPrint_ = new ParProcessPrint(this);
        this.paraPrint_ = new ParaPrint(this);
        this.paraListPrint_	= new ParaListPrint(this);
        this.programPrint_ = new ProgramPrint(this);
        this.operPrint_ = new OperPrint(this);
        this.relacionamentos_ = new ArrayList<Relacionamento>();
        this.isSchema_ = false;
        this.counterRow = 0;
        this.markUp = markUp.LATEX;
        this.percurso = new StringBuilder();
        this.inserirRelsAnn = false;
      }
    public Printer(boolean toInsert) {
      this.actionPrint_ = new ActionPrint(this);
      this.action2Print_ = new Action2Print(this);
      this.actionItePrint_ = new ActionItePrint(this);
      this.parActionPrint_ = new ParActionPrint(this);
      this.communPrint_ = new CommunPrint(this);
      this.commandPrint_ = new CommandPrint(this);
      this.exprPrint_ = new ExprPrint(this);
      this.exprListPrint_ = new ExprListPrint(this);
      this.predPrint_ = new PredPrint(this);
      this.declPrint_ = new DeclPrint(this);
      this.declListPrint_ = new DeclListPrint(this);
      this.namePrint_ = new NamePrint(this);
      this.nameListPrint_ = new NameListPrint(this);
      this.processPrint_ = new ProcessPrint(this);
      this.processItePrint_ = new ProcessItePrint(this);
      this.process2Print_ = new Process2Print(this);
      this.parProcessPrint_ = new ParProcessPrint(this);
      this.paraPrint_ = new ParaPrint(this);
      this.paraListPrint_ = new ParaListPrint(this);
      this.programPrint_ = new ProgramPrint(this);
      this.operPrint_ = new OperPrint(this);
      this.relacionamentos_ = new ArrayList<Relacionamento>();
      this.isSchema_ = false;
      this.markUp = Markup.LATEX;
      this.counterRow = 0;
      this.percurso = new StringBuilder();
      this.inserirRelsAnn = toInsert;
    }
    
    /**
     * Guarda o percurso do visitor sobre a AST
     * @return
     */
    public StringBuilder getPercurso(){
    	return percurso;
    }
    
  /**
   * Double check that this visitor is not being asked to visit a
   * non-Decl object.
   */
    public Object visitTerm(Term term)
    {
    	String[] result = null;
    	percurso = new StringBuilder();
    	if(term instanceof Pred) {
    		getPercurso().append("instance of Pred\n");
    		
    		relacionamentos_.clear();
    		result = (String[])term.accept(predPrint_);
    	}
    	else if(term instanceof Para) {
    		getPercurso().append("instance of Para\n");
    		relacionamentos_.clear();
    		result = (String[])term.accept(paraPrint_);
    	}
    	else if(term instanceof Spec) {
    		getPercurso().append("Instance of SPec\n");
    		relacionamentos_.clear();
    		result = (String[])term.accept(programPrint_);
    	}
    	else if(term instanceof Expr) {
    		getPercurso().append("Instance of Expr\n");
    		relacionamentos_.clear();
    		result = (String[])term.accept(exprPrint_);
    	}
    	else if(term instanceof net.sourceforge.czt.z.ast.Name) {
    		getPercurso().append("Instance of Name\n");
    		relacionamentos_.clear();
    		result = (String[])term.accept(namePrint_);
    	}
    	else if(term instanceof Decl) {
    		getPercurso().append("Instance of Decl\n");
    		relacionamentos_.clear();
    		result = (String[])term.accept(declPrint_);
    	}
    	else if(term instanceof net.sourceforge.czt.z.ast.DeclList) {
    		getPercurso().append("Instance of DeclList\n");
    		relacionamentos_.clear();
    		result = (String[])term.accept(declListPrint_);
    	}
    	else if(term instanceof CircusProcess) {
    		getPercurso().append("Instance of CircusProcess\n");
    		relacionamentos_.clear();
    		result = (String[])term.accept(processPrint_);
    	}
    	else if(term instanceof Name) {
    		getPercurso().append("Instance of Name\n");
    		relacionamentos_.clear();
    		result = (String[])term.accept(namePrint_);
    	}
    	else if(term instanceof NameList) {
    		getPercurso().append("Instance of NameList\n");
    		relacionamentos_.clear();
    		result = (String[])term.accept(nameListPrint_);
    	}
    	else if(term instanceof SchText) {
    		getPercurso().append("Instance of SchText\n");
    		relacionamentos_.clear();
    		result = (String[])term.accept(paraPrint_);
    	}
    	else if (term instanceof ChannelSet){
    		getPercurso().append("Instance of ChannelSet\n");
    		relacionamentos_.clear();
    		result = (String[])term.accept(exprPrint_);
    	}   	
    	else {
    		getPercurso().append("instance of Action\n");
    		relacionamentos_.clear();
    		result = (String[])term.accept(actionPrint_);
    	}
    	return result;
    }

    
    
    public String[] visitTermTactic(Term term)
    {
    	String[] result = null;
    	percurso = new StringBuilder();
    	if(term instanceof Pred) {
    		getPercurso().append("instance of Pred\n");

    		result = (String[])term.accept(predPrint_);
    	}
    	else if(term instanceof Para) {
    		getPercurso().append("instance of Para\n");

    		result = (String[])term.accept(paraPrint_);
    	}
    	else if(term instanceof Spec) {
    		getPercurso().append("Instance of SPec\n");

    		result = (String[])term.accept(programPrint_);
    	}
    	else if(term instanceof Expr) {
    		getPercurso().append("Instance of Expr\n");

    		result = (String[])term.accept(exprPrint_);
    	}
    	else if(term instanceof net.sourceforge.czt.z.ast.Name) {
    		getPercurso().append("Instance of Name\n");

    		result = (String[])term.accept(namePrint_);
    	}
    	else if(term instanceof Decl) {
    		getPercurso().append("Instance of Decl\n");

    		result = (String[])term.accept(declPrint_);
    	}
    	else if(term instanceof net.sourceforge.czt.z.ast.DeclList) {
    		getPercurso().append("Instance of DeclList\n");
    
    		result = (String[])term.accept(declListPrint_);
    	}
    	else if(term instanceof CircusProcess) {
    		getPercurso().append("Instance of CircusProcess\n");
    	
    		result = (String[])term.accept(processPrint_);
    	}
    	else if(term instanceof Name) {
    		getPercurso().append("Instance of Name\n");
    	
    		result = (String[])term.accept(namePrint_);
    	}
    	else if(term instanceof NameList) {
    		getPercurso().append("Instance of NameList\n");
    		
    		result = (String[])term.accept(nameListPrint_);
    	}
    	else if(term instanceof SchText) {
    		getPercurso().append("Instance of SchText\n");
    		
    		result = (String[])term.accept(paraPrint_);
    	}
    	else if (term instanceof ChannelSet){
    		getPercurso().append("Instance of ChannelSet\n");
    		
    		result = (String[])term.accept(exprPrint_);
    	}
    	else {
    		getPercurso().append("instance of Action\n");
    
    		result = (String[])term.accept(actionPrint_);
    	}
    	return result;
    }
    public List<Relacionamento> getRelacionamentos() {
    	return this.relacionamentos_;
    }

	public boolean isToInserirRelsAnn() {
		return inserirRelsAnn;
	}

	public void setInserirRelsAnn(boolean inserirRelsAnn) {
		this.inserirRelsAnn = inserirRelsAnn;
	}

	/**
	 * 
	 * @param termo
	 * @return Texto de um termo no formato LATEX
	 */
	public static String printLATTEX(Term termo) {
		return Printer.printAll(termo, Markup.LATEX, false);
	}

	public Print getActionPrint_() {
		return actionPrint_;
	}

	public void setActionPrint_(Print actionPrint_) {
		this.actionPrint_ = actionPrint_;
	}

	public Print getActionItePrint_() {
		return actionItePrint_;
	}

	public void setActionItePrint_(Print actionItePrint_) {
		this.actionItePrint_ = actionItePrint_;
	}

	public Print getCommunPrint_() {
		return communPrint_;
	}

	public void setCommunPrint_(Print communPrint_) {
		this.communPrint_ = communPrint_;
	}

	public Print getCommandPrint_() {
		return commandPrint_;
	}

	public void setCommandPrint_(Print commandPrint_) {
		this.commandPrint_ = commandPrint_;
	}

	public Print getExprPrint_() {
		return exprPrint_;
	}

	public void setExprPrint_(Print exprPrint_) {
		this.exprPrint_ = exprPrint_;
	}

	public Print getPredPrint_() {
		return predPrint_;
	}

	public void setPredPrint_(Print predPrint_) {
		this.predPrint_ = predPrint_;
	}

	public Print getDeclPrint_() {
		return declPrint_;
	}

	public void setDeclPrint_(Print declPrint_) {
		this.declPrint_ = declPrint_;
	}

	public Print getDeclListPrint_() {
		return declListPrint_;
	}

	public void setDeclListPrint_(Print declListPrint_) {
		this.declListPrint_ = declListPrint_;
	}

	public Print getProcessPrint_() {
		return processPrint_;
	}

	public void setProcessPrint_(Print processPrint_) {
		this.processPrint_ = processPrint_;
	}

	public Print getProcess2Print_() {
		return process2Print_;
	}

	public void setProcess2Print_(Print process2Print_) {
		this.process2Print_ = process2Print_;
	}

	public Print getProcessItePrint_() {
		return processItePrint_;
	}

	public void setProcessItePrint_(Print processItePrint_) {
		this.processItePrint_ = processItePrint_;
	}

	public Print getParProcessPrint_() {
		return parProcessPrint_;
	}

	public void setParProcessPrint_(Print parProcessPrint_) {
		this.parProcessPrint_ = parProcessPrint_;
	}

	public Print getParaPrint_() {
		return paraPrint_;
	}

	public void setParaPrint_(Print paraPrint_) {
		this.paraPrint_ = paraPrint_;
	}

	public Print getParaListPrint_() {
		return paraListPrint_;
	}

	public void setParaListPrint_(Print paraListPrint_) {
		this.paraListPrint_ = paraListPrint_;
	}

	public Print getProgramPrint_() {
		return programPrint_;
	}

	public void setProgramPrint_(Print programPrint_) {
		this.programPrint_ = programPrint_;
	}

	public Print getAction2Print_() {
		return action2Print_;
	}

	public void setAction2Print_(Print action2Print_) {
		this.action2Print_ = action2Print_;
	}

	public Print getParActionPrint_() {
		return parActionPrint_;
	}

	public void setParActionPrint_(Print parActionPrint_) {
		this.parActionPrint_ = parActionPrint_;
	}

	public Print getExprListPrint_() {
		return exprListPrint_;
	}

	public void setExprListPrint_(Print exprListPrint_) {
		this.exprListPrint_ = exprListPrint_;
	}

	public Print getNamePrint_() {
		return namePrint_;
	}

	public void setNamePrint_(Print namePrint_) {
		this.namePrint_ = namePrint_;
	}

	public Print getNameListPrint_() {
		return nameListPrint_;
	}

	public void setNameListPrint_(Print nameListPrint_) {
		this.nameListPrint_ = nameListPrint_;
	}

	public Print getOperPrint_() {
		return operPrint_;
	}

	public void setOperPrint_(Print operPrint_) {
		this.operPrint_ = operPrint_;
	}


	public Text getTipo() {
		return tipo;
	}

	public void setTipo(Text tipo) {
		this.tipo = tipo;
	}

	public List<Relacionamento> getRelacionamentos_() {
		return relacionamentos_;
	}

	public void setRelacionamentos_(List<Relacionamento> relacionamentos_) {
		this.relacionamentos_ = relacionamentos_;
	}

	public int getCounterRow() {
		return counterRow;
	}

	public void setCounterRow(int counterRow) {
		this.counterRow = counterRow;
	}

	public boolean isSchema_() {
		return isSchema_;
	}

	public void setSchema_(boolean isSchema_) {
		this.isSchema_ = isSchema_;
	}

	public ZSect getCurrentZSect() {
		return currentZSect;
	}

	public void setCurrentZSect(ZSect currentZSect) {
		this.currentZSect = currentZSect;
	}

	public Markup getMarkUp() {
		return markUp;
	}

	public void setMarkUp(Markup markUp) {
		this.markUp = markUp;
	}

	public List<Pair> getPairs_() {
		return pairs_;
	}

	public void setPairs_(List<Pair> pairs_) {
		this.pairs_ = pairs_;
	}

	public boolean isInserirRelsAnn() {
		return inserirRelsAnn;
	}

	public void setPercurso(StringBuilder percurso) {
		this.percurso = percurso;
	}

	
}
