/*
 * Print.java
 *
 * Created on 12 de Setembro de 2005, 19:54
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package circusRefine.core.print;

import java.util.LinkedList;
import java.util.List;

import javax.swing.JOptionPane;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.session.Markup;
import net.sourceforge.czt.z.ast.ZSect;
import circusRefine.core.Relacionamento;
import circusRefine.core.idt.IdtAnn;
import circusRefine.core.idt.IdtCommentAnn;
import circusRefine.core.idt.IdtUtils;
import circusRefine.core.util.TesteTermVisitor;
import circusRefine.core.util.Text;
import circusRefine.util.ComentariosUtils;
import circusRefine.util.Identificador;
import circusRefine.util.NatToRoman;

/**
 *
 * @author comp
 */
abstract public class Print implements TermVisitor {

	protected Printer printer_;
	protected static String BRANCO = "   ";
	protected static String Space = " ";

	protected Text getTexto() {
		return printer_.tipo;
	}
	
	/** Creates a new instance of Print */
	public Print(Printer printer) {
		this.printer_ = printer;
	}
	

	protected Print actionPrint() {
		return printer_.actionPrint_;
	}

	protected Print exprListPrint() {
		return printer_.exprListPrint_;
	}

	protected Print namePrint() {
		return printer_.namePrint_;
	}

	protected Print action2Print() {
		return printer_.action2Print_;
	}
	protected Print actionItePrint() {
		return printer_.actionItePrint_;
	}
	
	protected Print parActionPrint() {
		return printer_.parActionPrint_;
	}

	protected Print paraLisPrint() {
		return printer_.paraListPrint_;
	}

	protected Print communPrint() {
		return printer_.communPrint_;
	}

	protected Print commandPrint() {
		return printer_.commandPrint_;
	}

	protected Print exprPrint() {
		return printer_.exprPrint_;
	}

	protected Print predPrint() {
		return printer_.predPrint_;
	}

	protected Print declPrint() {
		return printer_.declPrint_;
	}

	protected Print nameListPrint(){
		return printer_.nameListPrint_;
	}
	
	protected Print declLisPrint() {
		return printer_.declListPrint_;
	}

	protected Print processPrint() {
		return printer_.processPrint_;
	}
	
	protected Print processItePrint() {
		return printer_.processItePrint_;
	}
	
	protected Print processPrint2() {
		return printer_.process2Print_;
	}

	protected Print ParProcessPrint() {
		return printer_.parProcessPrint_;
	}
	
	protected Print OperPrint() {
		return printer_.operPrint_;
	}


	protected Print programPrint() {
		return printer_.programPrint_;
	}

	protected Print paraPrint() {
		return printer_.paraPrint_;
	}

	protected List relacionamentos() {
		return printer_.relacionamentos_;
	}

	protected void addRelacionamento(Relacionamento rel) {
		relacionamentos().add(rel);
	}

	protected boolean isSchema() {
		return printer_.isSchema_;
	}

	protected boolean isToInsertingRelAnn(){
		return printer_.isToInserirRelsAnn();
	}

	protected void setIsSchema(boolean isSchema) {
		printer_.isSchema_ = isSchema;
	}
	protected boolean getUnicoded() {
		if (printer_.markUp == Markup.UNICODE) {
			return true;
		}
		else {
			return false;
		}
	}

	protected StringBuilder getPercurso() {
		return printer_.percurso;
	}

	protected ZSect getCurrentZSection() {
		return printer_.currentZSect;	 
	}
	protected void setCurrentZSection (ZSect current) {
		printer_.currentZSect = current;
	}

	protected int getCounterRow() {
		return printer_.counterRow;
	}
	protected void addCounterRow(int adder) {
		this.printer_.counterRow += adder;
	}
	protected void setCounterRow(int row) {
		this.printer_.counterRow = row;
	}
	/*
	 * Utilizado por DocGenerator
	 */
	public String inserindoIdentificador (Term term, String str, IdtAnn identificadorComentario) {

		if (!getTexto().equals(Text.ESPECIFICACAO_ORIGINAL)) {
			if (str.endsWith("\\\\")){
				str = str.substring(0, str.length() -3);
			}
			if (IdtUtils.haveIdt(term, Identificador.LEI)){	
				/*
				 * Verifica essa instancia do termo foi realmente a que foi aplicada a lei
				 */
				boolean b = IdtUtils.haveIdt(term, Identificador.COLETANDO);
				if (b) {
					if (IdtUtils.getId(term, Identificador.COLETANDO).getIdt() > 0) {
						IdtUtils.removeIdtTermoColetado(term);
						return str;
					}
				}
				//Nao sofreu coleta de codigo
				
					str = str + BRANCO  + "\\t1" + 
					NatToRoman.natToRom(IdtUtils.getId(term, Identificador.LEI).getIdt(), 0).toUpperCase() + " ";
				if (IdtUtils.haveIdt(term, Identificador.OBRIGACAO)) {
						
					String aux = NatToRoman.natToRom(IdtUtils.getId(term, Identificador.OBRIGACAO).getIdt(), 0);
					str = str + " , OP(" 
					+ aux.substring(1, aux.length()-1).toUpperCase() 
					+ ") " ;
				}
				if (IdtUtils.haveCommentIdt(term)) {

					LinkedList<IdtCommentAnn> lista = IdtUtils.listIdtComments(term);

					for (int i = 0; i< lista.size();i++) {
						if (!lista.get(i).foiVisitado()) {
							if (lista.get(i).getContadorColetas() > 0) {
								lista.get(i).decrContador();
							}
							else if (lista.get(i).getContadorColetas() == 0) {
								lista.get(i).setJaVisitado(true);
								lista.get(i).setJaVisitado(true);
								str = str + " C(" 
								+ lista.get(i).getIdt() + ")" ;
								identificadorComentario.setIdt(lista.get(i).getIdt());
							}
						}
					}


				}
				str = str + "  \\\\";
				return str;
			}
			/*  Possui apenas comentario*/
			else if (IdtUtils.haveCommentIdt(term)) {
				if (str.endsWith("\\\\")){
					str = str.substring(0, str.length() -3);
				}
				LinkedList<IdtCommentAnn> lista = IdtUtils.listIdtComments(term);

				for (int i = 0; i< lista.size();i++) {
					if (!lista.get(i).foiVisitado()) {
						if (lista.get(i).getContadorColetas() > 0) {
							lista.get(i).decrContador();
						}
						else if (lista.get(i).getContadorColetas() == 0) {
							lista.get(i).setJaVisitado(true);
							str = str + " \\t1  C(" 
							+ lista.get(i).getIdt() + ")   \\\\" ;
							identificadorComentario.setIdt(lista.get(i).getIdt());
						}
					}
				}
				str = str + "  \\\\";
			}
		}
		return str;
	}
	
	protected String[] inserirComentario(String[] result, IdtAnn identificadorComentario) {
		
		//TODO encapsular o texto;
		StringBuffer text = new StringBuffer(); 
		boolean check = ComentariosUtils.getComentarioTxt(identificadorComentario.getIdt(), text);
		if (check) {
			String[] textFrag = text.toString().split("\n");
			
			if (getTexto() == Text.DES_COMENTARIOS_ANTES) {
				int novoTamano = result.length + textFrag.length;
				String novoResult[] = new String[novoTamano];
				int index = 0;
				novoResult[index++] = "C(" + identificadorComentario.getIdt() + ") : \\t1  "
				+ textFrag[0] + "\\\\";
				for (int i = 1; i<textFrag.length;i++) {
					novoResult[index++] = textFrag[i] + "\\\\";
				}
				for (int i=0;i<result.length;i++) {
					novoResult[index++] = result[i] + "\\\\";
				}
				return novoResult;
			}
			else if (getTexto() == Text.DES_COMENTARIOS_DEPOIS) {
				int novoTamano = result.length + textFrag.length;
				String novoResult[] = new String[novoTamano];
				int index = 0;
				for (int i = 0; i<result.length;i++) {
					novoResult[index++] = result[i] + "\\\\";
				}
				novoResult[index++] = "C(" + identificadorComentario.getIdt() + ") : \\t1  "
				+ textFrag[0] + "\\\\";
				for (int i= 1;i<textFrag.length;i++) {
					novoResult[index++] = textFrag[i] + "\\\\";
				}	
					
				return novoResult;
			}
			return result;
		}
		return result;
	}
	
	/**
	 * 
	 * @return Uma string contendo as declaracoes de modo a
	 * aquelas que estao com ; estarem unidas.
	 */
	public String[] returnDeclaracoes(String[] declarations)  {
		LinkedList<String> stringsDecls = new LinkedList<String>();
		int count = 0;
		stringsDecls.add(declarations[0]);
		for (int i=1;i< declarations.length;i++) {
			if (!declarations[i].contains("\\\\") && !stringsDecls.get(count).contains("\\\\")) {
				stringsDecls.set(count, stringsDecls.get(count) + declarations[i]);
			}
			else {
				count++;
				stringsDecls.add(declarations[i]);
			}
		}
		String [] result = new String[stringsDecls.size()];
		for (int i=0;i<stringsDecls.size();i++){
			result[i] = stringsDecls.get(i);
		}	
		return result;
	}
	
	protected void printTeste (String[] str){
		System.out.println("-----BEGIN");
			for (String a : str) {
				System.out.println(a);
			}
		System.out.println("-----END");
		
	}
	
	protected void insertBeginEndSymbols (String[] result, String begin, String end) {
		result[0] = begin + result[0];
		result[result.length-1] += end;
	}
	
	
	protected void debugTeste (String[] texto) {
		for (int i=0; i< texto.length;i++) {
			if (texto[i].contains("////") || texto[i].contains("\\\\") ) {
				System.err.println(texto[i]);
				int x =1;
			}
		}
	}
	
	public Object visitTerm(Term term)
	{
		System.out.println(this.getClass().getName() +
				" being asked to visit " +
				term.getClass().getName());
		return null;
	}

}
