/*
 * PredPrint.java
 *
 * Created on 13 de Setembro de 2005, 09:12
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package circusRefine.core.print;

import java.util.List;


import net.sourceforge.czt.circus.ast.ActionTransformerPred;
import net.sourceforge.czt.circus.ast.ProcessTransformerPred;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circus.util.CircusString;
import net.sourceforge.czt.circus.visitor.ActionTransformerPredVisitor;
import net.sourceforge.czt.circus.visitor.ProcessTransformerPredVisitor;
import net.sourceforge.czt.z.ast.*;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.z.visitor.*;
import net.sourceforge.czt.zpatt.ast.JokerPred;
import net.sourceforge.czt.zpatt.visitor.JokerPredVisitor;

/**
 *
 * @author comp
 */
public class PredPrint 
extends Print
implements QntPredVisitor,
Pred2Visitor,
AndPredVisitor,
MemPredVisitor,
NegPredVisitor,
ExprPredVisitor,
PredVisitor,
TruePredVisitor,
FalsePredVisitor,
ActionTransformerPredVisitor,
ProcessTransformerPredVisitor,
JokerPredVisitor{

	/** Creates a new instance of PredPrint */
	public PredPrint(Printer printer) {
		super(printer);
	}

	public Object visitPred(Pred pred)
	{		
		getPercurso().append("Pred\n");
		return pred.accept(this);
	}

	public Object visitTruePred(TruePred pred) {
		getPercurso().append("TruePred\n");
		String[] result = new String[1];
		if (!getUnicoded()){
			result[0] = "\\true";
		}
		else {
			result[0] = ZString.TRUE;
		}
		return result;
	}

	public Object visitFalsePred(FalsePred pred) {
		String[] result = new String[1];
		getPercurso().append("FalsePred\n");
		if (!getUnicoded()){
			result[0] = "\\false";
		}
		else {
			result[0] = ZString.FALSE;
		}
		return result;
	}

	/**
	 * Exists1Pred, ExistsPred, and ForallPred instances are
	 * visited as an instance of their super class QntPred.
	 */
	public Object visitQntPred(QntPred qntPred)
	{
		String[] result = null;

		getPercurso().append("QntPred\n");

		String str = "";
		int index = 1;

		if (!getUnicoded()) {

			if(qntPred instanceof ForallPred) {
				str = str + "\\forall ";
			}
			else if(qntPred instanceof ExistsPred) {
				str = str + "\\exists ";
			}
			else if(qntPred instanceof Exists1Pred) {
				str = str + "\\exists_1 ";
			}
		}
		else {
			if(qntPred instanceof ForallPred) {
				str = str + ZString.ALL ;
			}
			else if(qntPred instanceof ExistsPred) {
				str = str + ZString.EXI;
			}
			else if(qntPred instanceof Exists1Pred) {
				str = str + ZString.EXIONE;
			}
		}

		String[] strPred = (String[])qntPred.getPred().accept(this);
		String[] strSchText = (String[])qntPred.getSchText().accept(exprPrint());
		result = new String[strPred.length + strSchText.length - 1];

		result[0] = str + strSchText[0];
		for(int i=1; i<strSchText.length; i++) {
			result[index] = strSchText[i];
			index++;
		}
		index--;
		if (!getUnicoded()) {
			result[index] = result[index] + " @ " + strPred[0];
		}
		else {
			result[index] = result[index] + Space + ZString.SPOT + Space + strPred[0];
		}
		index++;
		for(int i=1; i<strPred.length; i++) {
			result[index] = strPred[i];
			index++;
		}


		return result;
	}

	/**
	 * IffPred, ImpliesPred, and OrPred instances are
	 * visited as an instance of their super class Pred2.
	 */
	public Object visitPred2(Pred2 pred2)
	{
		String[] result = null;

		getPercurso().append("Pred2\n");

		String str = "";
		String[] strPredL = (String[])pred2.getLeftPred().accept(this);
		String[] strPredR = (String[])pred2.getRightPred().accept(this);
		result = new String[strPredL.length + strPredR.length - 1];

		int index = 1;
		result[0] = "(" + strPredL[0];
		for(int i=1; i< strPredL.length; i++) {
			result[index++] = strPredL[i];
		}
		index--;
		if (!getUnicoded()) {
			if(pred2 instanceof IffPred) {
				str = str + " \\iff ";
			}
			else if(pred2 instanceof ImpliesPred) {
				str = str + " \\implies ";
			}
			else if(pred2 instanceof OrPred) {
				str = str + " \\lor ";
			}
		}
		else {
			if(pred2 instanceof IffPred) {
				str = str + ZString.IFF;
			}

			else if(pred2 instanceof ImpliesPred) {
				str = str + ZString.IMP;
			}
			else if(pred2 instanceof OrPred) {
				str = str + ZString.OR;
			}
		}
		result[index] = result[index] + str + strPredR[0];
		index++;
		for(int i=1; i<strPredR.length; i++) {
			result[index++] = strPredR[i];
		}
		index--;
		result[index] = result[index] + ")";



		return result;
	}

	/**
	 * AndPred instances are visited separately from Pred2 instances
	 * because they have extra requires if they are a chain relation.
	 */
	public Object visitAndPred(AndPred andPred)
	{		
		String[] result = null;
		getPercurso().append("AndPred\n");
		

		int index = 0;
		String[] strPredL = (String[])andPred.getLeftPred().accept(this);
		String[] strPredR = (String[])andPred.getRightPred().accept(this);

		And and = andPred.getAnd();

		// AND.NL - >        a = b //
		//				   b = c Like schemas

		// AND.Wedge ->  	   a = b \land b = c
		//AND.SEMI - >       a = b ; b = c
		//AND.Chain ->       a = b = c;

		if(and.equals(And.NL)) {
			result = new String[strPredL.length + strPredR.length];
		}
		else {
			result = new String[strPredL.length + strPredR.length - 1];
		}

		for(int i=0; i < strPredL.length; i++) {
			result[index] = strPredL[i];
			index++;
		}
		if(and.equals(And.Wedge) || and.equals(And.Chain)) {
			result[0] = "(" + result[0];
			index = index-1;
			if (!getUnicoded()) {
				result[index] = result[index] + Space +"\\land"+ Space + strPredR[0];
			}
			else {
				result[index] = result[index] + ZString.AND  + strPredR[0] ;
			}
			index++;
			
			for(int i=1; i < strPredR.length; i++) {
				 result[index++] = strPredR[i] ;
			}
			result[result.length-1] +=  ")";
			return result;
		}
		if(and.equals(And.NL)) {
			for(int i=0; i < strPredR.length; i++) {
				result[index] = strPredR[i];
				index++;
			}
			return result;
		}
		if(and.equals(And.Semi)) {
			index = index-1;
			for(int i=0; i < strPredR.length; i++) {
				result[index] = result[index] + Space + ZString.SEMI 
				+ Space + strPredR[i];
				index++;
			}
		}
		return result;
	}

	public Object visitMemPred(MemPred memPred)
	{
		getPercurso().append("MeMPred\n");
		String[] result = null;

		Expr exprL = (Expr)memPred.getLeftExpr();
		Expr exprR = (Expr)memPred.getRightExpr();

		String[] strExprL = (String[])exprL.accept(exprPrint());

		String[] strExprR = (String[])exprR.accept(exprPrint());


		String mixfix = " = ";

		if(memPred.getMixfix()) {
			if(exprR instanceof RefExpr) {
				String name = ((String[])((RefExpr)exprR).getName().accept(namePrint()))[0];
				//LATEX
				if (!getUnicoded()) {
					if(name.equals(ZString.ARG_TOK + ZString.NEQ + ZString.ARG_TOK)) {
						mixfix = " \\neq ";
					}
					else if(name.equals(ZString.ARG_TOK + ZString.NOTMEM + ZString.ARG_TOK)) {
						mixfix = " \\notin ";
					}
					else if(name.equals(ZString.ARG_TOK + ZString.MEM + ZString.ARG_TOK)) {
						mixfix = " \\in ";
					}
					else if(name.equals(ZString.ARG_TOK + ZString.SUBSETEQ + ZString.ARG_TOK)) {
						mixfix = " \\subseteq ";
					}
					else if(name.equals(ZString.ARG_TOK + ZString.SUBSET + ZString.ARG_TOK)) {
						mixfix = " \\subset ";
					}
					else if(name.equals(ZString.ARG_TOK + ZString.CAP + ZString.ARG_TOK)) {
						mixfix = " \\cap ";
					}
					else if(name.equals(ZString.ARG_TOK + "partition" + ZString.ARG_TOK)) {
						mixfix = " \\partition ";
					}
					else if(name.equals(ZString.ARG_TOK + ZString.LEQ + ZString.ARG_TOK)) {
						mixfix = " \\leq ";
					}
					else if(name.equals(ZString.ARG_TOK + ZString.GEQ + ZString.ARG_TOK)) {
						mixfix = " \\geq ";
					}
					else if(name.equals(ZString.ARG_TOK + ZString.LESS + ZString.ARG_TOK)) {
						mixfix = " < ";
					}
					else if(name.equals(ZString.ARG_TOK + ZString.GREATER + ZString.ARG_TOK)) {
						mixfix = " > ";
					}
					else if(name.equals(ZString.ARG_TOK + ZString.SUBSET + ZString.ARG_TOK)) {
						mixfix = " \\subset ";
					}
					else if(name.equals(ZString.ARG_TOK + ZString.SUBSETEQ + ZString.ARG_TOK)) {
						mixfix = " \\subseteq ";
					}
					else if(name.equals(ZString.ARG_TOK + ZString.REL + ZString.ARG_TOK)) {
						mixfix = " \\rel ";
					}
					else {
						mixfix = " = ";
					}
				}
				//UNICODE
				else {
					if(name.equals(ZString.ARG_TOK + ZString.NEQ + ZString.ARG_TOK)) {
						mixfix = Space + ZString.NEQ + Space;
					}
					else if(name.equals(ZString.ARG_TOK + ZString.MEM + ZString.ARG_TOK)) {
						mixfix = Space + ZString.MEM + Space;
					}
					else if(name.equals(ZString.ARG_TOK + ZString.SUBSETEQ + ZString.ARG_TOK)) {
						mixfix = Space + ZString.SUBSETEQ + Space;
					}
					else if(name.equals(ZString.ARG_TOK + ZString.SUBSET + ZString.ARG_TOK)) {
						mixfix = Space + ZString.SUBSET + Space;
					}
					else if(name.equals(ZString.ARG_TOK + "partition" + ZString.ARG_TOK)) {
						mixfix = Space + "partition" + Space;
					}
					else if(name.equals(ZString.ARG_TOK + ZString.LEQ + ZString.ARG_TOK)) {
						mixfix = Space + ZString.LEQ + Space;
					}
					else if(name.equals(ZString.ARG_TOK + ZString.GEQ + ZString.ARG_TOK)) {
						mixfix = Space + ZString.GEQ + Space;
					}
					else if(name.equals(ZString.ARG_TOK + ZString.LESS + ZString.ARG_TOK)) {
						mixfix = Space + ZString.LESS + Space;
					}
					else if(name.equals(ZString.ARG_TOK + ZString.GREATER + ZString.ARG_TOK)) {
						mixfix = Space + ZString.GREATER + Space;
					}
					else if(name.equals(ZString.ARG_TOK + ZString.REL + ZString.ARG_TOK)) {
						mixfix = Space + ZString.REL + Space;
					}
					else if(name.equals(ZString.ARG_TOK + ZString.SUBSET + ZString.ARG_TOK)) {
						mixfix = Space + ZString.SUBSET + Space;
					}
					else if(name.equals(ZString.ARG_TOK + ZString.SUBSETEQ + ZString.ARG_TOK)) {
						mixfix = Space + ZString.SUBSETEQ + Space;
					}
					else {
						mixfix = Space + ZString.EQUALS + Space;
					}
				}
				if(exprL instanceof TupleExpr) {
					TupleExpr tuple = (TupleExpr)exprL;
					List<Expr> exprs = tuple.getZExprList();
					strExprL = (String[])exprs.get(0).accept(exprPrint());
					strExprR = (String[])exprs.get(1).accept(exprPrint());
				}
			}
		}
		else {
			if (!getUnicoded()) {
				mixfix = Space + "\\in" + Space;
			}
			else{
				mixfix =  Space + ZString.MEM +  Space ;
			}
		}

		// não sei porque, mas a igualdade sempre tem um SetExpr como expressão
		// da direita. Ao inves de ficar: y=x, ficava: y={x}... Fiz esse 'arrumadinho'
		// para resolver isto...
		if(mixfix.equals(" = ") && (exprR instanceof SetExpr)) {
			Expr newExprR = (Expr)((SetExpr)exprR).getZExprList().get(0);
			strExprR = (String[])newExprR.accept(exprPrint());
		}
		//
		result = new String[strExprL.length + strExprR.length - 1];
		int index = 1;
		result[0] = "(" + strExprL[0];
		for(int i=1; i<strExprL.length; i++) {
			result[index++] = strExprL[i];
		}
		index--;
		result[index] = result[index] + mixfix + strExprR[0];
		index++;
		for(int i=1; i<strExprR.length; i++) {
			result[index++] = strExprR[i];
		}
		index--;
		result[index] = result[index] + ")";

		return result;
	}

	public Object visitNegPred(NegPred negPred)
	{
		getPercurso().append("NegPred\n");
		String[] result = null;

		String[] strPred = (String[])negPred.getPred().accept(this);
		result = new String[strPred.length];
		if (!getUnicoded()) {
			result[0] = "\\lnot(" + strPred[0];
		}
		else{
			result[0] = ZString.NOT + "(" + strPred[0]; 
		}
		int index = 1;
		for(int i=1; i<strPred.length; i++) {
			result[index++] = strPred[i];
		}
		index--;
		result[index] = result[index] + ")";

		return result;
	}

	public Object visitExprPred(ExprPred exprPred)
	{
		getPercurso().append("ExprPred\n");
		String[] result = (String[])exprPred.getExpr().accept(exprPrint());
		return result;
	}

	public Object visitActionTransformerPred(ActionTransformerPred term) {
		getPercurso().append("ActionTransformerPred\n");

		String[] result= null;
		String[] spec = null;
		String[] impl = null;
		int linhaInicial = this.getCounterRow();

		Transformation symbolTrans = term.getTransformation();
		/* symbol - Refinamento, Equival�ncia ou Simula�ão*/
		String symbol = this.getSymbol(symbolTrans);

		/* spec \circrefines impl*/
		spec = (String[])term.getSpec().accept(actionPrint());
		this.addCounterRow(1);
		impl = (String[])term.getImpl().accept(actionPrint());

		result = new String[spec.length + impl.length + 1];

		int index = 0;
		for (int i =0;i< spec.length;i++) {
			result[index++] =  BRANCO + spec[i];
		}
		result[index++]= symbol;
		for (int i = 0; i< impl.length;i++) {
			result[index++]= BRANCO + impl[i]; 
		}

		this.setCounterRow(linhaInicial + result.length);

		return result;
	}

	public Object visitProcessTransformerPred(ProcessTransformerPred term) {
		getPercurso().append("ProcessTransformerPred\n");

		String[] result= null;
		String[] spec = null;
		String[] impl = null;

		int linhaInicial = this.getCounterRow();

		Transformation symbolTrans = term.getTransformation();
		/* symbol - Refinamento, Equivalência ou Simulação*/
		String symbol = this.getSymbol(symbolTrans);

		/* spec \circrefines impl*/
		spec = (String[])term.getSpec().accept(processPrint());
		this.addCounterRow(1);
		impl = (String[])term.getImpl().accept(processPrint());

		/* Verifica qual sera o maior tamanho do actionTransformerPred*/
		result = new String[spec.length + impl.length + 1];

		int index = 0;
		for (int i =0;i< spec.length;i++) {
			result[index++] =  BRANCO + spec[i];
		}
		result[index++]= symbol;
		for (int i = 0; i< impl.length;i++) {
			result[index++]= BRANCO + impl[i]; 
		}

		this.setCounterRow(linhaInicial + result.length);

		return result;

	}

	protected String getSymbol(Transformation t) {
		String result = "";
		if (!getUnicoded()) {
			if (t.equals(Transformation.Equivalence)){
				result = "=";
			}
			else if (t.equals(Transformation.Refinement)){
				result = "\\circrefines";
			}
			else {
				result = "\\circsimulates";
			}
		}
		else {
			if (t.equals(Transformation.Equivalence)){
				result = "=";
			}
			else if (t.equals(Transformation.Refinement)){
				result = " " + CircusString.CIRCREFINES;
			}
			else {
				result = CircusString.CIRCSIMULATES;
			}
		}

		return result;
	}

	public Object visitJokerPred(JokerPred term) {
		getPercurso().append("JokerPred\n");
		String[] result = new String[1];
		result[0] = term.getName();

		return result;
	}

}
