package circusRefine.core.print;

/**
 * Classe que incorpora os visitors referentes a parte ParProcesses da Circus AST
 * @author Alessandro
 */
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.circus.util.CircusString;
import net.sourceforge.czt.circus.ast.AlphabetisedParallelProcess;
import net.sourceforge.czt.circus.ast.InterleaveProcess;
import net.sourceforge.czt.circus.ast.ParallelProcess;
import net.sourceforge.czt.circus.visitor.AlphabetisedParallelProcessVisitor;
import net.sourceforge.czt.circus.visitor.InterleaveProcessVisitor;
import net.sourceforge.czt.circus.visitor.ParallelProcessVisitor;

public class ParProcessPrint extends Print 
implements InterleaveProcessVisitor ,
AlphabetisedParallelProcessVisitor,
ParallelProcessVisitor{

	public ParProcessPrint(Printer printer) {
		super(printer);
	}
//	Process ::= Process \interleave Process
	public Object visitInterleaveProcess(InterleaveProcess arg0) {
		String[] result = new String[1];

		if (!getUnicoded()) {
			result[0] = "\\interleave";
		}
		else{
			result[0] = CircusString.INTERLEAVE;
		}
		return result;
	}
	//Process ::= Process |[CSExpression | CSExpression]| Process
	public Object visitAlphabetisedParallelProcess(AlphabetisedParallelProcess term) {

		String[] result = new String[1];

		String strCSL = ((String[])term.getLeftAlpha().accept(exprPrint()))[0];
		String strCSR = ((String[])term.getRightAlpha().accept(exprPrint()))[0];

		result[0] = BRANCO + "\\lpar " + strCSL + " | " + strCSR + " \\rpar";

		return result;
	}


	// Process ::= Process |[CSExpression]| Process
	public Object visitParallelProcess(ParallelProcess term) {

		String strCS = ((String[])term.getChannelSet().accept(exprPrint()))[0];
		String[] result = new String[1];
		if (!getUnicoded())
			result[0] = BRANCO + "\\lpar" + Space + strCS + Space + "\\rpar"; 
		else
			result[0] = BRANCO + CircusString.LPAR + Space + strCS + Space + CircusString.RPAR;

		return result;
	}

}
