package circusRefine.core.print;

/**
 * @author Alessandro, esse eh o kra!
 */
import javax.swing.JOptionPane;

import net.sourceforge.czt.circus.util.CircusString;
import net.sourceforge.czt.circus.ast.AlphabetisedParallelAction;
import net.sourceforge.czt.circus.ast.InterleaveAction;
import net.sourceforge.czt.circus.ast.ParallelAction;
import net.sourceforge.czt.circus.visitor.AlphabetisedParallelActionVisitor;
import net.sourceforge.czt.circus.visitor.InterleaveActionVisitor;
import net.sourceforge.czt.circus.visitor.ParallelActionVisitor;
import net.sourceforge.czt.circuspatt.ast.JokerAction;

public class ParActionPrint 
extends Print 
implements  ParallelActionVisitor ,
			InterleaveActionVisitor , 
			AlphabetisedParallelActionVisitor {
	
	/** Creates a new instance of ActionPrint */
	public ParActionPrint(Printer printer) {
		super(printer);
	}
	
	public Object visitParallelAction (ParallelAction term) {
		
		getPercurso().append("ParallelAction\n");
		int linhaInicial = this.getCounterRow();
		
		String strNSL = ((String[])term.getLeftNameSet().accept(exprPrint()))[0];
		String strNSR = ((String[])term.getRightNameSet().accept(exprPrint()))[0];
		String strCS = ((String[])term.getChannelSet().accept(exprPrint()))[0];

		String[] result = new String[1];

		if (!getUnicoded())
			result[0] = BRANCO + "\\lpar" + Space + strNSL + Space + "|" 
			+ Space + strCS + Space + "|" + Space + strNSR + Space + "\\rpar"; 
		else
			result[0] = BRANCO + CircusString.LPAR + Space + strNSL + Space + "|" 
			+ Space + strCS + Space + "|" + Space + strNSR + Space + CircusString.RPAR;

		return result;
	}
	
	public Object visitInterleaveAction (InterleaveAction term) {

		String[] result = null;
		
		//caso ActionLeft[ ns1 ||| ns2} ActionRight
		if (term.getLeftNameSet() != null && term.getRightNameSet() != null) {
			
			result = new String[1];
			String strNSL = ((String[])term.getLeftNameSet().accept(exprPrint()))[0];
			String strNSR = ((String[])term.getRightNameSet().accept(exprPrint()))[0];

			if (!getUnicoded())
				result[0] = BRANCO + "\\linter" + Space + strNSL + Space +"|" + Space 
				+ strNSR + Space + "\\rinter"; 
			else
				result[0] = BRANCO + CircusString.LINTER + Space + strNSL + Space +"|" + Space 
				+ strNSR + Space + CircusString.RINTER;
		}
		//caso ActionLEft( ActionRight)
		else {
			String[] left = (String[])term.getLeftAction().accept(actionPrint());
			String[] right = (String[])term.getRightAction().accept(actionPrint());
			
			result = new String[left.length + right.length -1];
			int index = 0;
			for (int i=0; i < left.length;i++) {
				result[index++] = left[i];
			}
			index--;
			result[index] = result[index] + " (" + right[0];
			index++;
			for (int i=1; i < right.length;i++) {
				result[index++] = right[i];
			}
			index--;
			result[index] += ")";
			
		}
		return result;
	}
	
	public Object visitAlphabetisedParallelAction (AlphabetisedParallelAction term) {
		
		String strNSL = ((String[])term.getLeftNameSet().accept(exprPrint()))[0];
		String strNSR = ((String[])term.getRightNameSet().accept(exprPrint()))[0];
		String strCSL = ((String[])term.getLeftAlpha().accept(exprPrint()))[0];
		String strCSR = ((String[])term.getRightAlpha().accept(exprPrint()))[0];

		String result[] = new String[1];
		
		if (!getUnicoded())
			result[0] = BRANCO + "\\lpar" + Space + strNSL + Space + "|" 
			+ Space + strCSL + Space + "|" + Space + strCSR + Space + "|" + Space + strNSR + Space + "\\rpar"; 
		else
			result[0] = BRANCO + CircusString.LPAR + Space + strNSL + Space + "|" 
			+ Space + strCSL + Space + "|" + Space + strCSR + Space + "|" + Space + strNSR + Space + CircusString.RPAR;
		return result;
	}
}
