package circusRefine.core.print;

import javax.swing.JOptionPane;

import net.sourceforge.czt.z.ast.Operand;
import net.sourceforge.czt.z.ast.Operator;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.z.visitor.OperandVisitor;
import net.sourceforge.czt.z.visitor.OperatorVisitor;

public class OperPrint extends Print
implements
OperandVisitor,
OperatorVisitor{

	public OperPrint(Printer printer) {
		super(printer);
	}

	public Object visitOperand(Operand term) {
		String result[] = new String[1];
		result[0] = "";
		if (!term.getList()){
			if (!getUnicoded()) {
				result[0] += "\\" + ZString.ARG_TOK + Space;
			}
			else{
				result[0] += ZString.ARG_TOK + Space;
			}
		}
		
		return result;
	}

	public Object visitOperator(Operator term) {
		String[] result = new String[1];
		result[0] = term.getWord();
		String str = term.getWord();
		
		//TODO verificar lista de operadores
		/* LATTEX*/
		if (!getUnicoded()){
			if (str.startsWith(ZString.NE + ZString.PLUS + ZString.SW + ZString.ARG)){
				str = "\\plus";
			}
		}
		/* UNICODE*/
		else{
			if (str.startsWith(ZString.NE + ZString.PLUS + ZString.SW + ZString.ARG)){
				str = ZString.PLUS;
			}
		}
		str += Space;
		result[0] = str;
		
		return result;
	}

}
