	package circusRefine.core.print;

import javax.swing.JOptionPane;

import net.sourceforge.czt.base.ast.Digit;
import net.sourceforge.czt.circus.util.CircusString;
import net.sourceforge.czt.z.ast.InStroke;
import net.sourceforge.czt.z.ast.NextStroke;
import net.sourceforge.czt.z.ast.NumStroke;
import net.sourceforge.czt.z.ast.OutStroke;
import net.sourceforge.czt.z.ast.Stroke;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.z.visitor.ZNameVisitor;
import net.sourceforge.czt.zpatt.ast.JokerName;
import net.sourceforge.czt.zpatt.visitor.JokerNameVisitor;

public class NamePrint extends 
Print
implements 
JokerNameVisitor ,
ZNameVisitor{
	
	/** Creates a new instance of ActionPrint */
	public NamePrint(Printer printer) {
		super(printer);
	}

	public Object visitJokerName(JokerName term) {
		String[] result = new String[1];
		result[0] = term.getName();
		return result;
	}

	public Object visitZName(ZName name) {
		String[] result = new String[1];
		String str = name.getWord();
		
		if (str.endsWith("_") && !str.startsWith("_")){
			str = str.substring(0, str.length()-1);
			str += "\\_";
		}
		if (str.equals("\u03B1")) {
			str = "\\alpha";
		}
    	if(name.getZStrokeList() != null 
    			&& !(name.getZStrokeList().isEmpty())) {
    		for (Stroke stroke :name.getZStrokeList()) {

    			if(stroke instanceof InStroke) {
    				str = str + ZString.INSTROKE;
    			}
    			else if(stroke instanceof OutStroke) {
    				str = str + ZString.OUTSTROKE;
    			}
    			else if (stroke instanceof NumStroke) {

    				NumStroke numstroke = (NumStroke)stroke;
    				Digit digit = numstroke.getDigit();
    				str = str + ZString.ARG_TOK + digit.getValue();
    			}
    			else if(stroke instanceof NextStroke) {
    				str = str + "'";
    			}
    		}
    	}
    	result[0] = str;
    	if (str.contains("State _ 1")) {
    		int k= 10;
    	}
    	
    	return result;
	}
	

}
