package circusRefine.core.print;

import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.ZNameList;
import net.sourceforge.czt.z.visitor.ZNameListVisitor;
import net.sourceforge.czt.zpatt.ast.JokerNameList;
import net.sourceforge.czt.zpatt.visitor.JokerNameListVisitor;

public class NameListPrint extends Print
implements ZNameListVisitor,
JokerNameListVisitor{

	public NameListPrint(Printer printer) {
		super(printer);
	}

	public Object visitZNameList(ZNameList vars) {
		
		String[] result = new String[1];
		int counter = 0;
		int size = vars.size();
		result[0] = "";
		
		for(Name name : vars) {
			  String str = ((String[])name.accept(namePrint()))[0];
			  result[0] = result[0] + str;
			  if(counter < size-1) {
				  result[0] = result[0] + Space + "," + Space;
			  }
			  counter++;
		  }
		return result;
	}
	public Object visitJokerNameList(JokerNameList term) {
		
		String[] result = new String[1];
		result[0] = term.getName();
		
		return result;
	}
}