/*
 * ExprPrint.java
 *
 * Created on 12 de Setembro de 2005, 20:01
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package circusRefine.core.print;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.swing.JOptionPane;

import net.sourceforge.czt.base.ast.Digit;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.oz.ast.PredExpr;
import net.sourceforge.czt.oz.visitor.PredExprVisitor;
import net.sourceforge.czt.z.ast.*;
import net.sourceforge.czt.z.visitor.*;
import net.sourceforge.czt.circus.ast.*;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circus.visitor.*;
import circusRefine.core.*;
import circusRefine.core.annotations.StatementSchExprAnn;
import circusRefine.core.astmodifiers.CommunicationArgumentAnn;
import circusRefine.core.astmodifiers.ActionArgumentAnn;
import circusRefine.core.astmodifiers.ProcessArgumentAnn;
import circusRefine.core.opsdischarge.OPsDischargeUtils;
import circusRefine.core.relations.RelationsAnn;
import circusRefine.core.relations.RelationsAnnStack;
import circusRefine.core.relations.RelationsUtils;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.zpatt.ast.JokerExpr;
import net.sourceforge.czt.zpatt.visitor.JokerExprVisitor;
import net.sourceforge.czt.circus.util.CircusString;
import net.sourceforge.czt.circuspatt.ast.JokerChannelSet;
import net.sourceforge.czt.circuspatt.ast.JokerNameSet;
import net.sourceforge.czt.circuspatt.visitor.JokerChannelSetVisitor;
import net.sourceforge.czt.circuspatt.visitor.JokerNameSetVisitor;
/**
 *
 * @author comp
 */
public class ExprPrint 
extends Print
implements SchTextVisitor,
RefExprVisitor,
PowerExprVisitor,
ProdExprVisitor,
SetExprVisitor,
SetCompExprVisitor,
NumExprVisitor,
SchExprVisitor,
TupleExprVisitor,
TupleSelExprVisitor,
Qnt1ExprVisitor,
LambdaExprVisitor,
MuExprVisitor,
LetExprVisitor,
SchExpr2Visitor,
NegExprVisitor,
CondExprVisitor,
PipeExprVisitor,
HideExprVisitor,
ProjExprVisitor,
PreExprVisitor,
ApplExprVisitor,
ThetaExprVisitor,
DecorExprVisitor,
RenameExprVisitor,
BindSelExprVisitor,
BindExprVisitor,
ChannelSetVisitor,
NameSetVisitor,
BasicChannelSetExprVisitor,
JokerNameSetVisitor,
JokerChannelSetVisitor,
JokerExprVisitor,
PredExprVisitor,
SchExprActionVisitor
{

	private boolean isSeq;

	/** Creates a new instance of ExprPrint */
	public ExprPrint(Printer printer) {
		super(printer);
		isSeq = false; // variavel auxiliar que retorna se a expressao 
		//em questao � uma < .. > (trata-se de uma sequencia)
	}

	public Object visitBasicChannelSetExpr(BasicChannelSetExpr term) {
		getPercurso().append("BasicChannelSetExpr\n");
		String[] result = new String[1];
		int cont = 0;
		List<Communication> comunications = term.getCircusCommunicationList();
		String str = "";
		String str2 = "";
		if (!getUnicoded()) {
			str = "\\lchanset" + Space;
			str2 = Space + "\\rchanset";
		}
		else {
			str = CircusString.LCIRCCHANSET + Space;
			str2 = Space + CircusString.RCIRCCHANSET;
		}
		int size = comunications.size();

		for (int i=0; i< comunications.size();i++){
			if (i == 1){
				String last = ((String[])comunications.get(i-1).accept(communPrint()))[0];
				String estaIte = ((String[])comunications.get(i).accept(communPrint()))[0];
				if (last != estaIte){
					str = str + estaIte;
					if (cont < size && size !=1) {
						str = str + ", ";  
					}
					cont++;
				}

			}
			else {
				String channel = ((String[])comunications.get(i).accept(communPrint()))[0];
				str = str + channel;
				if (cont < size && size !=1) {
					str = str + ", ";  
				}
				cont++;
			}
		}


		str = str + str2;

		result[0] = str;
		return result;
	}

	public Object visitSchText(SchText term)
	{
		getPercurso().append("schTExt do Exper\n");
		String[] result = null;

		ZSchText schText = (ZSchText)term;

		DeclList decls = schText.getDeclList();
		int counter = 0;
		String[] strDecl = null;
		String[] strPred = null;

		if (schText.getPred() != null) {
			strPred = (String[])schText.getPred().accept(predPrint());
		}
		/* Schema Vertical*/
		if(isSchema()) {

			strDecl = (String[])schText.getDeclList().accept(declLisPrint());

			if (strPred != null) {
				result = new String[strDecl.length + strPred.length + 1];}
			else{
				result = new String[strDecl.length + 2];
			}
			int index = 0;
			for(int i=0; i<strDecl.length; i++) {
				result[index++] = BRANCO + strDecl[i];
			}
			result[index++] = "\\where";
			if (strPred != null) {
				for(int i=0; i<strPred.length; i++) {
					result[index++] = strPred[i];
				}

			}
			else {
				if (!getUnicoded())
					result[index++] = "\\true";
				else 
					result[index++] = "true";
			}
		} /*a = [ ... | ... ] */
		else {


			String [] declarations = (String[])decls.accept(declLisPrint());
			String[]  strdecl;
			if (declarations.length > 0 ){
				strdecl = this.returnDeclaracoes(declarations);
			}
			else {
				strdecl = new String[1];
				strdecl[0] = "";
			}

			if (strPred != null) {
				result = new String[strdecl.length + strPred.length -1];}
			else{
				result = new String[strdecl.length];
			}

			int index = 0;
			for(int i=0; i<strdecl.length; i++) {
				result[index++] = strdecl[i];
			}
			index--;
			result[index] += " | ";

			if (strPred != null) {
				if (strPred.length == 1)
					result[index++] += strPred[0] + Space ;
				else {
					//Caso em que o predicado provavelmente � um AndPred com New Line
					result[index++] += strPred[0] + Space +"\\\\";
					for (int i=1;i< strPred.length -1;i++ ) {
						result[index++] = strPred[i] + Space + "\\\\";
					}

					result[result.length-1] = strPred[strPred.length-1] + Space ;
				}
			}
			else {
				if (!getUnicoded())
					result[index] += " \\true ";
				else 
					result[index] += " true ";
			}
		}
		return result;
	}

	public Object visitRefExpr(RefExpr refExpr)
	{
		getPercurso().append("RefExpr\n");
		String[] result = new String[1];
		String str = "";
		int linhaInicial = this.getCounterRow();    

		/* Verificando se essa RefExpr � uma lista de arguementos de funcao*/

		ActionArgumentAnn acao = refExpr.getAnn(ActionArgumentAnn.class);
		if (acao != null) {
			String[] resAction = (String[])acao.getTerm().accept(actionPrint());
			return resAction;
		}

		ProcessArgumentAnn process = refExpr.getAnn(ProcessArgumentAnn.class);
		if (process != null){
			String[] resProc = (String[])process.getTerm().accept(processPrint());
			return resProc;
		}

		CommunicationArgumentAnn annotation = refExpr.getAnn(CommunicationArgumentAnn.class);
		if (annotation != null){
			String[] resProc = (String[])annotation.getTerm().accept(communPrint());
			return resProc;
		}

		str = ((String [])refExpr.getName().accept(namePrint()))[0];
		boolean isImplicit = false;
		String [] strImplicit = null;
		if (!getUnicoded()) {

			if (str.equals(ZString.ARITHMOS)) {
				str = "\\arithmos" + Space;
			}
			else if(str.equals(ZString.NAT)) {
				str = "\\nat";
			}
			else if (str.startsWith(CircusUtils.DEFAULT_IMPLICIT_PROCESS_NAME_PREFIX)) {
				/*Guardara a string retornada pelo visitor do processo implicito*/
				Map<ZName, CircusProcess> implicitProcess;
				implicitProcess = CircusUtils.getZSectImplicitProcessPara(this.getCurrentZSection());
				CircusProcess implProcess = implicitProcess.get(refExpr.getZName());
				this.addCounterRow(-1);
				strImplicit = ((String[])implProcess.accept(processPrint()));
				isImplicit = true;
			}
			else if  (str.startsWith(ZString.XI)) {
				String aux = str.substring(1, str.length());
				str = "\\Xi" + Space + aux;
			}
			else if (str.equals(ZString.EMPTYSET)) {
				str = "\\emptyset";
			}
			else if (str.equals(CircusString.BOOLEAN)) {
				str = "\\boolean";
			}
			else if (str.equals(ZString.NAT + ZString.ARG_TOK + 1 )) {
				str = "\\nat_1";
			}
			else if  (str.equals(ZString.NUM)) {
				str = "\\num";
			}
			else if(str.equals("#"+ZString.ARG_TOK)) {
				str = "\\#";
			}
			else if(str.equals(ZString.FINSET + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExpr = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				str = "\\finset";
				str = str + Space + strExpr;
			}
			else if(str.equals(ZString.MINUS + ZString.ARG_TOK)) {
				str = "\\negate";
			}
			else if(str.equals("min" + ZString.ARG_TOK)) {
				str = "\\min";
			}
			else if(str.equals("seq" + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String[] strExpr = ((String[])((Expr)exprs.get(0)).accept(this));
				str = "\\seq" + Space;
				return strExpr;
			}
			else if (str.startsWith(ZString.DELTA)) {
				str = str.replaceAll(ZString.DELTA, " \\\\Delta ");
			}
			else if(str.equals("iseq" + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String[] strExpr = ((String[])((Expr)exprs.get(0)).accept(this));
				str = "\\iseq" + Space;

				return strExpr;
			}
			else if(str.equals("succ" + ZString.ARG_TOK)) {
				str = "\\succ";
			}
			else if (str.equals("\\alpha")) {
				String res = ((String[])(refExpr.getExprList().accept(exprListPrint())))[0];
				res = "( " + res + " )";
				str = str  + res ; 
			}
			else if (str.equals("DFV_Expr")) {
				String res = ((String[])(refExpr.getExprList().accept(exprListPrint())))[0];
				res = "( " + res + " )";
				str = str + res ; 
			}
			else if(str.equals(ZString.ARG_TOK + ZString.FUN + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExprL = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				String strExprR = ((String[])((Expr)exprs.get(1)).accept(this))[0];
				str = strExprL + " \\fun " + strExprR;
			}
			else if(str.equals(ZString.ARG_TOK + ZString.PFUN + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExprL = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				String strExprR = ((String[])((Expr)exprs.get(1)).accept(this))[0];
				str = strExprL + " \\pfun " + strExprR;
			}
			else if(str.equals(ZString.ARG_TOK + ZString.CAP + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				if (exprs.size() > 1) {
					String strExprL = ((String[])((Expr)exprs.get(0)).accept(this))[0];
					String strExprR = ((String[])((Expr)exprs.get(1)).accept(this))[0];
					str = strExprL + " \\cap " + strExprR;
				}
			}
			else if(str.equals(ZString.ARG_TOK + ZString.PINJ + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExprL = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				String strExprR = ((String[])((Expr)exprs.get(1)).accept(this))[0];
				str = strExprL + " \\pinj " + strExprR;
			}
			else if(str.equals(ZString.ARG_TOK + ZString.INJ + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExprL = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				String strExprR = ((String[])((Expr)exprs.get(1)).accept(this))[0];
				str = strExprL + " \\inj " + strExprR;
			}
			else if(str.equals(ZString.ARG_TOK + ZString.PSURJ + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExprL = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				String strExprR = ((String[])((Expr)exprs.get(1)).accept(this))[0];
				str = strExprL + " \\psurj " + strExprR;
			}
			else if(str.equals(ZString.ARG_TOK + ZString.SURJ + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExprL = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				String strExprR = ((String[])((Expr)exprs.get(1)).accept(this))[0];
				str = strExprL + " \\surj " + strExprR;
			}
			else if(str.equals(ZString.ARG_TOK + ZString.BIJ + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExprL = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				String strExprR = ((String[])((Expr)exprs.get(1)).accept(this))[0];
				str = strExprL + " \\bij " + strExprR;
			}
			else if(str.equals(ZString.ARG_TOK + ZString.FFUN + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExprL = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				String strExprR = ((String[])((Expr)exprs.get(1)).accept(this))[0];
				str = strExprL + " \\ffun " + strExprR;
			}
			else if(str.equals(ZString.ARG_TOK + ZString.FINJ + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExprL = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				String strExprR = ((String[])((Expr)exprs.get(1)).accept(this))[0];
				str = strExprL + " \\finj " + strExprR;
			}
			else if(str.equals(ZString.ARG_TOK + ZString.REL + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExprL = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				String strExprR = ((String[])((Expr)exprs.get(1)).accept(this))[0];
				str = strExprL + " \\rel " + strExprR;
			}
			else if (str.equals(ZString.LANGLE + Space + ZString.COMMA + ZString.COMMA + Space + ZString.RANGLE)){
				isSeq = true;
			}

			else if (str.equals(CircusUtils.DEFAULT_MAIN_ACTION_NAME)){
				str = "mainAction";
			}
	
			else if(str.contains(CircusString.UNIVERSE)){
				str = "\\universe";
			}

		}

		//CASO de impressao = UNICODE!
		else {

			if (str.equals(ZString.ARITHMOS)) {
				str = ZString.ARITHMOS + Space;
			}

			else if(str.equals("#"+ZString.ARG_TOK)) {
				str = "#";
			}
			
			else if (str.startsWith(CircusUtils.DEFAULT_IMPLICIT_PROCESS_NAME_PREFIX)) {

				/*Guardara a string retornada pelo visitor do processo implicito*/
				Map<ZName, CircusProcess> implicitProcess;
				implicitProcess = CircusUtils.getZSectImplicitProcessPara(this.getCurrentZSection());
				CircusProcess implProcess = implicitProcess.get(refExpr.getZName());
				strImplicit = ((String[])implProcess.accept(processPrint()));
				isImplicit = true;
			}

			else if(str.equals(ZString.FINSET + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExpr = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				str = ZString.FINSET;
				str = str + " " + strExpr;
			}
			else if(str.equals(ZString.MINUS + ZString.ARG_TOK)) {
				str = ZString.MINUS;
			}
			else if(str.equals("seq" + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String[] strExpr = ((String[])((Expr)exprs.get(0)).accept(this));
				str = "seq" + Space;
				return strExpr;
			}
			else if(str.equals("iseq" + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String[] strExpr = ((String[])((Expr)exprs.get(0)).accept(this));
				str = "iseq" + Space;
				return strExpr;
			}
			else if(str.equals(ZString.ARG_TOK + ZString.FUN + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExprL = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				String strExprR = ((String[])((Expr)exprs.get(1)).accept(this))[0];
				str = strExprL + Space + ZString.FUN + Space + strExprR;
			}
			else if(str.equals(ZString.ARG_TOK + ZString.PFUN + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExprL = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				String strExprR = ((String[])((Expr)exprs.get(1)).accept(this))[0];
				str = strExprL + Space + ZString.PFUN + Space + strExprR;
			}
			else if(str.equals(ZString.ARG_TOK + ZString.PINJ + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExprL = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				String strExprR = ((String[])((Expr)exprs.get(1)).accept(this))[0];
				str = strExprL + Space + ZString.PINJ + Space + strExprR;
			}
			else if(str.equals(ZString.ARG_TOK + ZString.INJ + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExprL = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				String strExprR = ((String[])((Expr)exprs.get(1)).accept(this))[0];
				str = strExprL + Space + ZString.INJ + Space + strExprR;
			}
			else if(str.equals(ZString.ARG_TOK + ZString.PSURJ + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExprL = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				String strExprR = ((String[])((Expr)exprs.get(1)).accept(this))[0];
				str = strExprL + Space + ZString.PSURJ + Space + strExprR;
			}
			else if(str.equals(ZString.ARG_TOK + ZString.SURJ + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExprL = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				String strExprR = ((String[])((Expr)exprs.get(1)).accept(this))[0];
				str = strExprL + Space + ZString.SURJ + Space + strExprR;
			}
			else if(str.equals(ZString.ARG_TOK + ZString.BIJ + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExprL = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				String strExprR = ((String[])((Expr)exprs.get(1)).accept(this))[0];
				str = strExprL + Space + ZString.BIJ + Space + strExprR;
			}
			else if (str.equals("\\alpha")) {
				String res = ((String[])(refExpr.getExprList().accept(exprListPrint())))[0];
				res = "( " + res + " )";
				str = str + res ; 
			}
			else if (str.equals("DFV_Expr")) {
				String res = ((String[])(refExpr.getExprList().accept(exprListPrint())))[0];
				res = "( " + res + " )";
				str = str +  res ; 
			}
			else if(str.equals("min" + ZString.ARG_TOK)) {
				str = "min";
			}
			else if(str.equals(ZString.ARG_TOK + ZString.FFUN + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExprL = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				String strExprR = ((String[])((Expr)exprs.get(1)).accept(this))[0];
				str = strExprL + Space + ZString.FFUN + Space + strExprR;
			}
			else if(str.equals(ZString.ARG_TOK + ZString.FINJ + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExprL = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				String strExprR = ((String[])((Expr)exprs.get(1)).accept(this))[0];
				str = strExprL + Space + ZString.FINJ + Space + strExprR;
			}
			else if(str.equals(ZString.ARG_TOK + ZString.REL + ZString.ARG_TOK)) {
				List<Expr> exprs = refExpr.getZExprList();
				String strExprL = ((String[])((Expr)exprs.get(0)).accept(this))[0];
				String strExprR = ((String[])((Expr)exprs.get(1)).accept(this))[0];
				str = strExprL + Space + ZString.REL + Space + strExprR;
			}
			else if (str.equals(ZString.LANGLE + Space + ZString.COMMA + ZString.COMMA + Space + ZString.RANGLE)){
				isSeq = true;
			}
			else if (str.equals(CircusUtils.DEFAULT_MAIN_ACTION_NAME)){
				str = "mainAction";
			}
			
			else if(str.equals(CircusString.UNIVERSE)){
				//str = "\u2a43";	
				//str = "\u0080";
				//str = "\u016a";
				str = "\u0055";
			}

		}
		if ( refExpr.getExplicit() 
				&& !refExpr.getMixfix() && !refExpr.getZExprList().isEmpty()){
			int size = refExpr.getZExprList().size();
			int counter = 0;
			String strGen = "";
			for(Expr expr : refExpr.getZExprList()) {

				if(counter == 0) {
					strGen = "[";
				}
				strGen = strGen + ((String [])expr.accept(this))[0];
				if(counter < size-1) {
					strGen = strGen + ",";
				} 
				else if(counter == size-1) {
					strGen = strGen + "]";
				}
				counter++;
			}
			str = str + strGen;
		}
		result[0] = str;
		
		/* Trata-se de um nome de operação num SchEpr2 (act1 \land \act2) Deve ter */

		if (isImplicit) {
			result = strImplicit;
		}

		return result;
	}


	public Object visitPowerExpr(PowerExpr powerExpr)
	{

		getPercurso().append("Power\n");
		String[] result = null;

		String[] expr = (String[])powerExpr.getExpr().accept(this);
		result = new String[expr.length];
		result[0] = "\\power " + expr[0];
		if (getUnicoded()) {
			result[0] = ZString.POWER + Space + expr[0];
		}
		int index = 1;
		for(int i=1; i<expr.length; i++) {
			result[index++] = expr[i];
		}

		return result;
	}

	public Object visitProdExpr(ProdExpr prodExpr)
	{
		getPercurso().append("pRODEXprzn");
		String[] result;

		String str = "";
		List<Expr> exprsLaw = prodExpr.getZExprList();

		String[] expressions =  (String[])prodExpr.getExprList().accept(exprListPrint());
		expressions = returnDeclaracoes(expressions);

		if (!getUnicoded()) {
			for (int i=0;i< expressions.length;i++) {
				expressions[i] = expressions[i].replaceAll(",", " \\cross " );
			}
		}
		else {
			for (int i=0;i< expressions.length;i++) {
				expressions[i] = expressions[i].replaceAll(",", Space + ZString.CROSS + Space);
			}
		}

		return expressions;
	}

	public Object visitSetExpr(SetExpr setExpr)
	{ 
		getPercurso().append("setExpr\n");
		String[] result;

		String[] expressions =  (String[])setExpr.getExprList().accept(exprListPrint());
		expressions = returnDeclaracoes(expressions);

		int size = expressions.length;
		if (size == 0) {
			result = new String[1];
			if (!getUnicoded())
				result[0] = "\\emptyset";
			else
				result[0] = ZString.EMPTYSET;
			return result;
		}
		else {
			if (!getUnicoded()) {
				insertBeginEndSymbols(expressions, "\\{", "\\}");
			}
			else{
				insertBeginEndSymbols(expressions, "\\{", "\\}");
			}
			return expressions;
		}
	}

	public Object visitNumExpr(NumExpr numExpr)
	{
		getPercurso().append("NumExpr\n");
		String[] result = new String[1];
		result[0] = numExpr.getValue().toString();
		return result;
	}

	public Object visitSchExpr(SchExpr schExpr)
	{	
		getPercurso().append("SchExpr\n");
		int linhaInicial = this.getCounterRow();
		String[] result;

		if (schExpr.getAnn(StatementSchExprAnn.class)!= null){
			result = ((String[])schExpr.getAnn(StatementSchExprAnn.class).getTermo().accept(actionPrint()));
		}
		else {
			result = ((String[])schExpr.getSchText().accept(this));
			if (!isSchema()) {
				if (result.length == 1) {
					result[0] = "[" + result[0] + "]";
				}
				else{
					result[0] = "[" + result[0];
					result[result.length -1] = result[result.length -1] + "]";
				}
			}
		}

		NoPrograma noProg = new NoPrograma(schExpr);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		this.setCounterRow(length +  linhaInicial);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, schExpr,isToInsertingRelAnn());
		addRelacionamento(rel);


		return result;	
	}

	public Object visitSetCompExpr(SetCompExpr setCompExpr)
	{

		getPercurso().append("SetCompExpr\n");
		String[] result = null;

		String str = "\\{";
		if (getUnicoded()){
			str = "{";
		}

		boolean anteriorSchema = this.isSchema(); //A impressao de esquema deve ser feita 

		this.setIsSchema(false);
		String[]  strSchText2 = ((String[])(setCompExpr.getSchText().accept(this)));
		this.setIsSchema(anteriorSchema);

		result = new String[strSchText2.length];
		for (int i=0; i< result.length;i++) {
			result[i] = strSchText2[i];
		}


		if (setCompExpr.getExpr() != null) {
			if (!getUnicoded()){
				String[] strExprs = ((String[])setCompExpr.getExpr().accept(this));
				result = new String[strSchText2.length + strExprs.length -1];

				int index =0;

				for (int i=0; i< result.length;i++) {
					result[index++] = strSchText2[i];
				}

				index--;
				result[index++] += Space + "@" + Space + strExprs[0] ;
				for (int i=1;i<strExprs.length;i++){
					result[index++] = strExprs[i];
				}

			}
			else {
				String[] strExprs = ((String[])setCompExpr.getExpr().accept(this));
				result = new String[strExprs.length];
				result[0] = str + Space + ZString.SPOT + Space + strExprs[0] ;
				for (int i=1;i<strExprs.length;i++){
					result[i] = strExprs[i];
				}
				result[result.length-1] += " }";
			}
		}
		else {

			result = new String[strSchText2.length];
			for (int i=0; i< result.length;i++) {
				result[i] = strSchText2[i];
			}
		}

		if (!getUnicoded()){
			insertBeginEndSymbols(result, "\\{","\\}");
		}
		//Space + "@" + Space + 
		else {
			insertBeginEndSymbols(result, "{", "}");
		}



		return result;
	}
	//13.2.6.6
	public Object visitTupleExpr(TupleExpr tupleExpr)
	{
		getPercurso().append("TupleExpr\n");
		String[] result;

		if (tupleExpr.getZExprList() != null) {
			result = ((String[])tupleExpr.getZExprList().
					accept(exprListPrint()));
			result = returnDeclaracoes(result);
			result[0] = "( " + result[0];
			result[result.length-1] += " )";

		}
		else {
			result = new String[1];
			result[0] = "( )";
		}

		return result;
	}
	/**
	 * C.6.26.1 TupleSelExpr
	 * Syntax
		Expression = ...
		| Expression , . , NUMERAL
		| ...
		;
	 */
	public Object visitTupleSelExpr(TupleSelExpr tupleSelExpr)
	{
		getPercurso().append("TupleSet\n");
		Numeral num = tupleSelExpr.getNumeral();
		ZNumeral numZ = (ZNumeral)num;
		String[] result = (String[])tupleSelExpr.getExpr().accept(this);
		result[0] = result[0] + "." +numZ.getValue();

		return result;
	}

	/**
	 * ExistsExpr, Exists1Expr, and ForallExpr instances are
	 * visited as an instance of their super class Qnt1Expr.
	 * Other Qnt1Expr instances are visited by their own visit
	 * methods
	 */
	public Object visitQnt1Expr(Qnt1Expr qnt1Expr)
	{
		getPercurso().append("Qnt1Expr\n");
		String[] result = null;

		String str = "";
		if (!getUnicoded()) {
			if(qnt1Expr instanceof ForallExpr) {
				str = "\\forall ";
			}
			else if(qnt1Expr instanceof ExistsExpr) {
				str = "\\exists ";
			}
			else if(qnt1Expr instanceof Exists1Expr) {
				str = "\\exists_1 ";
			}
		}
		else {
			if(qnt1Expr instanceof ForallExpr) {
				str = ZString.ALL + Space;
			}
			else if(qnt1Expr instanceof ExistsExpr) {
				str = ZString.EXI + Space;;
			}
			else if(qnt1Expr instanceof Exists1Expr) {
				str = ZString.EXIONE + Space;;
			}
		}
		String[] strSchText = (String[])qnt1Expr.getSchText().accept(this);
		String[] strExpr = (String[])qnt1Expr.getExpr().accept(this);
		result = new String[strExpr.length + strSchText.length - 1];

		if (!getUnicoded()) {
			result[0] = str + strSchText[0] + " @ ";
		}
		else {
			result[0] = str + strSchText[0] + Space + ZString.SPOT + Space;
		}
		int index = 1;
		for(int i=1; i<strSchText.length; i++) {
			result[index++] = strSchText[i];
		}
		index--;
		result[index] = result[index] + strExpr[0];
		index++;
		for(int i=1; i<strExpr.length; i++) {
			result[index++] = strExpr[i];
		}

		return result;
	}

	public Object visitLambdaExpr(LambdaExpr lambdaExpr)
	{ 
		getPercurso().append("Lambda\n");
		String[] result = null;

		String[] strExpr = (String[])lambdaExpr.getExpr().accept(this);
		String[] strSchText = (String[])lambdaExpr.getSchText().accept(this);
		result = new String[strExpr.length + strSchText.length - 1];

		if (!getUnicoded()) {
			result[0] = "\\lambda " + strSchText[0] + " @ ";
		}
		else {
			result[0] = ZString.LAMBDA + Space + strSchText[0] 
			                                                + Space + ZString.SPOT + Space;
		}
		int index = 1;
		for(int i=1; i<strSchText.length; i++) {
			result[index++] = strSchText[i];
		}
		index--;
		result[index] = result[index] + strExpr[0];
		index++;
		for(int i=1; i<strExpr.length; i++) {
			result[index++] = strExpr[i];
		}

		return result;
	}

	public Object visitMuExpr(MuExpr muExpr)
	{
		getPercurso().append("MuExpr\n");
		String[] result = null;

		String[] strExpr = (String[])muExpr.getExpr().accept(this);
		String[] strSchText = (String[])muExpr.getSchText().accept(this);
		result = new String[strExpr.length + strSchText.length - 1];
		if (!getUnicoded()) {
			result[0] = "\\mu " + strSchText[0] + " @ ";
		}
		else {
			result[0] = ZString.MU + Space + strSchText[0] 
			                                            + Space + ZString.SPOT + Space;
		}
		int index = 1;
		for(int i=1; i<strSchText.length; i++) {
			result[index++] = strSchText[i];
		}
		index--;
		result[index] = result[index] + strExpr[0];
		index++;
		for(int i=1; i<strExpr.length; i++) {
			result[index++] = strExpr[i];
		}

		return result;
	}

	public Object visitLetExpr(LetExpr letExpr)
	{
		getPercurso().append("LetExpr\n");
		String[] result = null;

		String[] strExpr = (String[])letExpr.getExpr().accept(this);
		String[] strSchText = (String[])letExpr.getSchText().accept(this);
		result = new String[strExpr.length + strSchText.length - 1];

		if (!getUnicoded())
			result[0] = "\\LET " + strSchText[0] + " @ ";
		else {
			result[0] = ZString.LET + Space + strSchText[0] 
			                                             + Space + ZString.SPOT + Space;
		}
		int index = 1;
		for(int i=1; i<strSchText.length; i++) {
			result[index++] = strSchText[i];
		}
		index--;
		result[index] = result[index] + strExpr[0];
		index++;
		for(int i=1; i<strExpr.length; i++) {
			result[index++] = strExpr[i];
		}

		return result;
	}


	/**
	 * AndExpr, OrExpr, IffExpr, and ImpliesExpr objects are visited as
	 * an instance of their superclass SchExpr2. Other SchExpr2 subclass
	 * instances have their own visit method, although ProjExprs use
	 * this visit method as well.
	 */
	public Object visitSchExpr2(SchExpr2 schExpr2)
	{
		getPercurso().append("SchExpr2\n");
		String[] result = null;

		int linhaInicial = this.getCounterRow();
		String str = "";
		String[] strL = (String[])schExpr2.getLeftExpr().accept(this);
		
		/** Trata-se de um RefExpr, guardamos a relação para */
		if (schExpr2.getLeftExpr().getAnn(RelationsAnnStack.class) == null){
				NoPrograma noProg = new NoPrograma(schExpr2.getLeftExpr());
				int length = strL.length;
				Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
				addRelacionamento(rel);
				RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial), schExpr2.getLeftExpr(),
						isToInsertingRelAnn());

				this.setCounterRow(length +  linhaInicial);
		}
		
		this.addCounterRow(1);
		String[] strR = (String[])schExpr2.getRightExpr().accept(this);
		/** Trata-se de um RefExpr, guardamos a relação para */
		if (schExpr2.getRightExpr().getAnn(RelationsAnnStack.class) == null){
			int linhaInicial2 = this.getCounterRow();
				NoPrograma noProg = new NoPrograma(schExpr2.getRightExpr());
				int length = strR.length;
				Relacionamento rel = new Relacionamento(linhaInicial2, linhaInicial2 + length -1, noProg);
				addRelacionamento(rel);
				RelationsUtils.insertRelation(new RelationsAnn(linhaInicial2, linhaInicial2+ length -1), schExpr2.getRightExpr(),
						isToInsertingRelAnn());

				this.setCounterRow(length +  linhaInicial2);
		}
		
		
		result = new String[strL.length + strR.length + 1];

		int index = 0;
		for(int i=0; i< strL.length; i++) {
			result[index++] = BRANCO +  strL[i];
		}
		//LATEX
		if (!getUnicoded()) {
			if(schExpr2 instanceof IffExpr) {
				str ="\\iff";
			}
			else if(schExpr2 instanceof ImpliesExpr) {
				str = "\\implies";
			}
			else if(schExpr2 instanceof OrExpr) {
				str = "\\lor";
			}
			else if(schExpr2 instanceof AndExpr) {
				str = "\\land";
			}
			else if(schExpr2 instanceof CompExpr) {
				str = "\\comp";
			}
			else if(schExpr2 instanceof PipeExpr) {
				str = "\\pipe";
			}
			else if(schExpr2 instanceof ProjExpr) {
				str = "\\project";
			}
		}
		//UNICODE
		else {
			if(schExpr2 instanceof IffExpr) {
				str =  ZString.IFF ;
			}
			else if(schExpr2 instanceof ImpliesExpr) {
				str =  ZString.IMP;
			}
			else if(schExpr2 instanceof OrExpr) {
				str = ZString.OR;
			}
			else if(schExpr2 instanceof AndExpr) {
				str = ZString.AND;
			}
			else if(schExpr2 instanceof CompExpr) {
				str = ZString.COMP;
			}
			else if(schExpr2 instanceof PipeExpr) {
				str = ZString.ZPIPE;
			}
			else if(schExpr2 instanceof ProjExpr) {
				str = ZString.ZPROJ;
			}
		}
		result[index++] = BRANCO + BRANCO + str ;
		for(int i=0; i<strR.length; i++) {
			result[index++] = BRANCO + strR[i];
		}

		NoPrograma noProg = new NoPrograma(schExpr2);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, schExpr2, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		return result;
	}

	public Object visitNegExpr(NegExpr negExpr)
	{
		getPercurso().append("Negexpr\n");
		String[] result = null;

		String[] strExpr = (String[])negExpr.getExpr().accept(this);
		result = new String[strExpr.length];
		if (!getUnicoded()) {
			result[0] = "\\lnot " + strExpr[0];
		}
		else {
			result[0] = Space + ZString.NOT + Space + strExpr[0];
		}
		int index = 1;
		for(int i=1; i<strExpr.length; i++) {
			result[index++] = strExpr[i];
		}

		return result;
	}

	public Object visitCondExpr(CondExpr condExpr)
	{
		getPercurso().append("visitCondExpr\n");
		String[] result = null;

		String[] strIf = (String[])condExpr.getLeftExpr().accept(this);
		String[] strThen = (String[])condExpr.getRightExpr().accept(this);
		String[] strElse = (String[])condExpr.getPred().accept(predPrint());
		result = new String[strIf.length + strThen.length + strElse.length - 2];
		if (!getUnicoded()) {
			result[0] = "\\IF " + strIf[0];
		}
		else {
			result[0] = ZString.IF + Space + strIf[0];
		}
		int index = 1;
		for(int i=1; i<strIf.length; i++) {
			result[index++] = strIf[i];
		}
		index--;

		if (!getUnicoded()) {
			result[index] = result[index] + " \\THEN "+ strThen[0];
		}
		else {
			result[index] = result[index] + Space + ZString.THEN + Space + strThen[0];
		}

		index++;
		for(int i=1; i<strThen.length; i++) {
			result[index++] = strThen[i];
		}
		index--;

		if (!getUnicoded()) {
			result[index] = result[index] + " \\ELSE " + strElse[0];
		}
		else {
			result[index] = result[index] + Space + ZString.ELSE + Space + strElse[0];
		}

		index++;
		for(int i=1; i<strElse.length; i++) {
			result[index++] = strElse[i];
		}

		return result;
	}


	public Object visitPipeExpr(PipeExpr pipeExpr)
	{
		getPercurso().append("PipeExpr\n");
		String[] result = null;

		int index=0;
		String[] strL = (String[])pipeExpr.getLeftExpr().accept(this);
		String[] strR = (String[])pipeExpr.getRightExpr().accept(this);
		result = new String[strL.length + strR.length - 1];
		for(int i=0; i<strL.length; i++) {
			result[index++] = strL[i];
		}
		index--;
		if (!getUnicoded()){
			result[index] = result[index] + " \\pipe " + strR[0];
		}
		else {
			result[index] = result[index] + Space + ZString.ZPIPE + Space + strR[0];
		}
		index--;
		for(int i=1; i<strR.length; i++) {
			result[index++] = strR[i];
		}

		return result;
	}

	//C.6.16
	public Object visitHideExpr(HideExpr hideExpr)
	{
		getPercurso().append("HideExpr\n");
		String[] result = null;

		String[] strExpr = (String[])hideExpr.getExpr().accept(this);
		result = new String[strExpr.length];

		int index = 0;
		for(int i=0; i<strExpr.length; i++) {
			result[index++] = strExpr[i];
		}
		index--;
		List<Name> namesLaw = hideExpr.getZNameList();
		int size = namesLaw.size();
		int counter = 0;
		String str = "";
		str = ((String[])hideExpr.getZNameList().accept(nameListPrint()))[0];

		if (!getUnicoded())
			result[index] = result[index] + Space + "\\hide" + Space + "(" + str +")";
		else
			result[index] = result[index] + Space + ZString.ZHIDE + Space + "(" + str +")";

		return result;
	}

	//C.6.17
	public Object visitProjExpr(ProjExpr projExpr)
	{
		getPercurso().append("ProjExpr\n");
		String[] result = null;

		int index=0;
		String[] strL = (String[])projExpr.getLeftExpr().accept(this);
		String[] strR = (String[])projExpr.getRightExpr().accept(this);
		result = new String[strL.length + strR.length - 1];
		for(int i=0; i<strL.length; i++) {
			result[index++] = strL[i];
		}
		index--;
		if (!getUnicoded()) {
			result[index] = result[index] + " \\project " + strR[0];
		}
		else {
			result[index] = result[index] + Space + ZString.ZPROJ + Space + strR[0];
		}
		for(int i=1; i<strR.length; i++) {
			result[index++] = strR[i];
		}

		return result;
	}

	//C.6.18
	public Object visitPreExpr(PreExpr preExpr)
	{	
		getPercurso().append("PreExpr\n");
		String[] result = null;

		if( (preExpr.getExpr() instanceof RefExpr)) {
			RefExpr refExpr = (RefExpr)preExpr.getExpr();
			String[] strSch = ((String[])refExpr.accept(exprPrint()));
			result = new String[strSch.length];
			if (!getUnicoded())
				result[0] = "\\pre(" + strSch[0];
			else
				result[0] = "pre(" + strSch + ")";

			for (int i=1; i< strSch.length; i++) {
				result[i] = strSch[i];
			}
			result[result.length-1]+=   ")";

			return result;
		}
			String[] strExpr = (String[])preExpr.getExpr().accept(this);
			result = new String[strExpr.length];
			if(!getUnicoded())
				result[0] = "\\pre(" + strExpr[0] + ")";
			else
				result[0] = "pre(" + strExpr[0] + ")";
			int index = 1;
			for(int i=1; i<strExpr.length; i++) {
				result[index++] = strExpr[i];
			}

		return result;
	}


	//C.6.21
	public Object visitApplExpr(ApplExpr applExpr)
	{
		getPercurso().append("ApplExpr\n");


		//Necessitara guarda relacionamentos sobre funcoes
		//como  \Xi e \Delta
		int linhaInicial = this.getCounterRow();

		String[] result = null;
		String[] strExprL = null;
		String[] strExprR = null;
		String str = "";

		//Devido a diferen�a de impressao de sequencias, foi feito esse
		//pequeno algoritmo para adapta��o do mesmo a forma de especifica��o original
		if (isSeq) {
			result = new String[1];
			if (!getUnicoded())
				result[0] = "\\langle" + Space;
			else
				result[0] = CircusString.LANGLE + Space;
			SetExpr exprR = (SetExpr)applExpr.getRightExpr();
			List<String> lista = new ArrayList<String> ();
			for (Expr expr : exprR.getZExprList()) {
				if (expr instanceof TupleExpr) {
					TupleExpr tupleExpr = (TupleExpr)expr;
					for (Expr expr2 : tupleExpr.getZExprList()) {
						if (expr2 instanceof RefExpr) {
							RefExpr refExpr = (RefExpr)expr2;
							lista.add(((String[])refExpr.getName().accept(namePrint()))[0]);
						}
					}
				}
			}
			int size = lista.size();
			int counter = 0;
			for (String str2 : lista){
				result[0] = result[0] + str2;
				if(counter < size-1) {
					result[0] = result[0] + Space + "," + Space;
				} 
				counter++;
			}
			if (!getUnicoded())
				result[0] = result[0] + Space + "\\rangle";
			else
				result[0] = result[0] + Space + CircusString.RANGLE;
			isSeq = false;
			return result;
		}

		Expr exprL = applExpr.getLeftExpr();
		Expr exprR = applExpr.getRightExpr();
		strExprL = (String[])exprL.accept(exprPrint());

		//Verificando se a parte esquerda � uma expressao de 
		// \Xi ou \Delta, nesse caso havera quebra de linha
		if (strExprL[0].startsWith("\\Xi") ||
				strExprL[0].startsWith("\\Delta")){
			addCounterRow(1);
		}

		strExprR = (String[])exprR.accept(exprPrint());

		String mixfix = "";

		if(applExpr.getMixfix()) {

			ZName refName = ((RefExpr)exprL).getZName();
			if (!getUnicoded()) {

				if(refName.getWord().equals(ZString.ARG_TOK + ZString.CUP + ZString.ARG_TOK)) {
					mixfix = " \\cup ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.CAP + ZString.ARG_TOK)) {
					mixfix = " \\cap ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.SETMINUS + ZString.ARG_TOK)) {
					mixfix = " \\setminus ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.SYMDIFF + ZString.ARG_TOK)) {
					mixfix = " \\symdiff ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.PLUS + ZString.ARG_TOK)) {
					mixfix = " + ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.MAPSTO + ZString.ARG_TOK)) {
					mixfix = " \\mapsto ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.REL + ZString.ARG_TOK)) {
					mixfix = " \\rel ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.COMP + ZString.ARG_TOK)) {
					mixfix = " \\comp ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.CIRC + ZString.ARG_TOK)) {
					mixfix = " \\circ ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.DRES + ZString.ARG_TOK)) {
					mixfix = " \\deres ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.RRES + ZString.ARG_TOK)) {
					mixfix = " \\rres ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.NDRES + ZString.ARG_TOK)) {
					mixfix = " \\ndres ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.NRRES + ZString.ARG_TOK)) {
					mixfix = " \\nrres ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.OPLUS + ZString.ARG_TOK)) {
					mixfix = " \\oplus ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.MINUS + ZString.ARG_TOK)) {
					mixfix = " - ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.MULT + ZString.ARG_TOK)) {
					mixfix = " \\times ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + "mod" + ZString.ARG_TOK)) {
					mixfix = " \\mod ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + "div" + ZString.ARG_TOK)) {
					mixfix = " \\div ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ".." + ZString.ARG_TOK)) {

					mixfix = " \\upto ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.CAT + ZString.ARG_TOK)) {
					mixfix = " \\cat ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.EXTRACT + ZString.ARG_TOK)) {
					mixfix = " \\extract ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.FILTER + ZString.ARG_TOK)) {
					mixfix = " \\filter ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.NOTMEM + ZString.ARG_TOK)) {
					mixfix = " \\notin ";
				}
				else if(refName.getWord().equals(  "min" + ZString.ARG_TOK)) {
					mixfix = " \\min ";
				}

			}
			//UNICODE
			else {
				if(refName.getWord().equals(ZString.ARG_TOK + ZString.CUP + ZString.ARG_TOK)) {
					mixfix = Space + ZString.CUP + Space;
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.CAP + ZString.ARG_TOK)) {
					mixfix = Space + ZString.CAP + Space;
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.SETMINUS + ZString.ARG_TOK)) {
					mixfix = Space + ZString.SETMINUS + Space;
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.SYMDIFF + ZString.ARG_TOK)) {
					mixfix = Space + ZString.SYMDIFF + Space;
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.PLUS + ZString.ARG_TOK)) {
					mixfix = Space + ZString.PLUS + Space;
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.MAPSTO + ZString.ARG_TOK)) {
					mixfix = Space + ZString.MAPSTO + Space;
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.REL + ZString.ARG_TOK)) {
					mixfix = Space + ZString.REL + Space;
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.COMP + ZString.ARG_TOK)) {
					mixfix = Space + ZString.COMP + Space;
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.CIRC + ZString.ARG_TOK)) {
					mixfix = Space + ZString.CIRC + Space;
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.DRES + ZString.ARG_TOK)) {
					mixfix = Space + ZString.DRES + Space;
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.RRES + ZString.ARG_TOK)) {
					mixfix = Space + ZString.RRES + Space;
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.NDRES + ZString.ARG_TOK)) {
					mixfix = Space + ZString.NDRES + Space;
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.NRRES + ZString.ARG_TOK)) {
					mixfix = Space + ZString.NRRES + Space;
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.OPLUS + ZString.ARG_TOK)) {
					mixfix = Space + ZString.OPLUS + Space;
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.MINUS + ZString.ARG_TOK)) {
					mixfix = Space + ZString.MINUS + Space;
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.MULT + ZString.ARG_TOK)) {
					mixfix = Space + ZString.MULT + Space;
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + "mod" + ZString.ARG_TOK)) {
					mixfix = " mod ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + "div" + ZString.ARG_TOK)) {
					mixfix = " div ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.CAT + ZString.ARG_TOK)) {
					mixfix = Space + ZString.CAT + Space;
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.EXTRACT + ZString.ARG_TOK)) {
					mixfix = Space + ZString.EXTRACT + Space;
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.FILTER + ZString.ARG_TOK)) {
					mixfix = Space + ZString.FILTER + Space;
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ".." + ZString.ARG_TOK)) {
					mixfix = " .. ";
				}
				else if(refName.getWord().equals(ZString.ARG_TOK + ZString.NOTMEM + ZString.ARG_TOK)) {
					mixfix = Space + ZString.NOTMEM + Space;
				}
				else if(refName.getWord().equals(  "min" + ZString.ARG_TOK)) {
					mixfix = " min ";
				}

			}
			if(exprR instanceof TupleExpr) {
				TupleExpr tuple = (TupleExpr)exprR;
				List<Expr> exprs = tuple.getZExprList();
				if (exprs.size() > 1) {
					strExprL = (String[])exprs.get(0).accept(exprPrint());
					strExprR = (String[])exprs.get(1).accept(exprPrint());
				}
				else {
					mixfix = " ";
					strExprR = (String[])exprs.get(0).accept(exprPrint());
				}
			}
			else {
				mixfix = " ";
			}
		}
		else {

			if (strExprL[0].startsWith("\\Xi") ||
					strExprL[0].startsWith("\\Delta")){
				result = new String[strExprL.length + strExprR.length];
				result[0] = "(" + strExprL[0];
				int index = 1;
				for (int i=0;i<strExprR.length;i++){
					result[index++] = BRANCO + strExprR[i];
				}
				index--;
				result[index] += ")";

				NoPrograma noProg = new NoPrograma(applExpr);
				int length = result.length;
				Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

				addRelacionamento(rel);
				RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
				, applExpr, isToInsertingRelAnn());
				this.setCounterRow(length +  linhaInicial);

				return result;

			}
			if (strExprL[0].equals(OPsDischargeUtils.DFV_Expr) 
					|| strExprL[0].equals(OPsDischargeUtils.DIVERGENCE_FREE) 
					|| strExprL[0].equals(OPsDischargeUtils.DETERMINISTIC)
					|| strExprL[0].equals(OPsDischargeUtils.FV_Action)
					|| strExprL[0].equals(OPsDischargeUtils.FV_Expr)
					|| strExprL[0].equals(OPsDischargeUtils.FV_Process)
					|| strExprL[0].equals(OPsDischargeUtils.INITIALS)
					|| strExprL[0].equals(OPsDischargeUtils.INPUT_VARS)
					|| strExprL[0].equals(OPsDischargeUtils.PRE)
					|| strExprL[0].equals(OPsDischargeUtils.STATE)
					|| strExprL[0].equals(OPsDischargeUtils.UDFV_Expr)
					|| strExprL[0].equals(OPsDischargeUtils.USED_C)
					|| strExprL[0].equals(OPsDischargeUtils.WRT_V)
					|| strExprL[0].equals(OPsDischargeUtils.USED_V)){

				// Removendo o ARG_TOK do Simbolo
				strExprL[0] = strExprL[0].substring(0, strExprL[0].length() -2);
			}
			if (strExprL[0].equals(OPsDischargeUtils.ALPHA)){
				if (!getUnicoded()) {
					strExprL[0] = "\\alpha ";
					/* Apesar do argumento de alpha ser um SchExpr
					 * Nao deve ser impresso com colchetes e sim com parentheses*/
					strExprR[0] = "(" + strExprR[0] + ")";
				}
				else {
					//TODO pedir pra colocarem alpha na CircusString CZT
					strExprL[0] = "\u03B1"; // codigo unicode de alfa
					strExprR[0] = "(" + strExprR[0] + ")";
				}
			}
			else if(exprR instanceof RefExpr ) {

				if (((RefExpr)exprR).getAnn(ActionArgumentAnn.class) != null ||
						(((RefExpr)exprR).getAnn(ProcessArgumentAnn.class) != null)) {
					String textTermo = "";
					// Faz a definicao da Acao horizontal
					for (int i=0;i<strExprR.length -1;i++) {
						textTermo += strExprR[i].trim() + " ";
					}
					textTermo += strExprR[strExprR.length - 1].trim(); 
					strExprR[0] = "(" + textTermo  + ")";
					//Nesse caso, todo o vetor de strExpR foi 
					//colocado em action. Logo toda a definicao da 
					//acao esta em uma linha que deve ser agora
					//apontada por strExpr
					String[] string = new String[1];
					string[0] = strExprR[0];
					strExprR = string;
				}
				//else if (((RefExpr)exprR).getAnn(ProcessArgumentAnn.class) != null){

				//}
				else { 
					strExprR[0] = "(" + strExprR[0]  + ")";
				}
				// eh uma aplica��o de fun��o comum: wrtV(X)
			}
			mixfix = " ";
		}

		result = new String[strExprL.length + strExprR.length - 1];
		int index = 0;

		result[index++] = "(" + strExprL[0];

		for(int i=1; i<strExprL.length; i++) {
			result[index++] = strExprL[i];
		}
		index--;
		result[index] = result[index] + mixfix + strExprR[0];
		index++;
		for(int i=1; i<strExprR.length; i++) {
			result[index++] = strExprR[i];
		}
		result[index-1] = result[index-1] + ")";


		return result;

	}

	public Object visitThetaExpr(ThetaExpr thetaExpr)
	{
		getPercurso().append("ThetaExpr\n");
		String[] result =null;

		String[] strExpr = (String[])thetaExpr.getExpr().accept(this);
		result = new String[strExpr.length];

		if (!getUnicoded()) {
			result[0] = "\\theta " + strExpr[0];
		}
		else {
			result[0] = ZString.THETA + Space + strExpr[0];
		}

		int index = 1;
		for(int i=1; i<strExpr.length; i++) {
			result[index++] = strExpr[i];
		}

		String strokeStr = "";

		if(thetaExpr.getZStrokeList() != null 
				&& !(thetaExpr.getZStrokeList().isEmpty())) {
			for (Stroke stroke :thetaExpr.getZStrokeList()) {

				if(stroke instanceof InStroke) {
					strokeStr = strokeStr + ZString.INSTROKE;
				}
				else if(stroke instanceof OutStroke) {
					strokeStr = strokeStr + ZString.OUTSTROKE;
				}
				else if (stroke instanceof NumStroke) {

					NumStroke numstroke = (NumStroke)stroke;
					Digit digit = numstroke.getDigit();
					strokeStr = strokeStr + ZString.ARG_TOK + digit.getValue();
				}
				else if(stroke instanceof NextStroke) {
					strokeStr = strokeStr + "'";
				}
			}
		}
		result[0] += strokeStr;

		return result;
	}

	public Object visitDecorExpr(DecorExpr decorExpr)
	{
		getPercurso().append("DecorEXpr\n");
		String[] result = null;
		String[] strExpr = (String[])decorExpr.getExpr().accept(this);

		result = new String[strExpr.length];
		int index = 0;
		for(int i=0; i<strExpr.length; i++) {
			result[index++] = strExpr[i];
		}
		index--;
		Stroke stroke = decorExpr.getStroke();
		String str = "";
		if(stroke instanceof InStroke) {
			str = str + ZString.INSTROKE;
		}
		else if(stroke instanceof OutStroke) {
			str = str + ZString.OUTSTROKE;
		}
		else if(stroke instanceof NextStroke) {
			str = str + "'";
		}
		result[index] = result[index] + str;

		return result;
	}

	public Object visitRenameExpr(RenameExpr renameExpr)
	{
		getPercurso().append("RenameExpr\n");
		String[] result = new String[1];

		String strExpr = ((String[])renameExpr.getExpr().accept(this))[0];

		String str = ""; // Parte a esquerda do ressign
		String strNew = "";// Pare a direita do ressign
		ZRenameList renameList = renameExpr.getZRenameList();
		int counter = 0;
		int size = renameList.size();

		for (NewOldPair newOldPair : renameList) {

			str = str + ((String [])newOldPair.getOldName().accept(namePrint()))[0];
			strNew = strNew + ((String [])newOldPair.getNewName().accept(namePrint()))[0]; 

			if(counter < size-1) {
				str = str + Space + "," + Space;
				strNew = strNew +  Space + "," + Space;
			}
			counter++;
		}

		if (!getUnicoded())
			result[0] = "\\lcircrename" + Space + str + Space + ":=" + Space 
			+ strNew + Space + "\\rcircrename";
		else
			result[0] = CircusString.LCIRCRENAME + Space + str + Space + ":=" 
			+ Space + strNew + Space + CircusString.RCIRCRENAME;

		result[0] = strExpr + result[0];

		return result;
	}

	public Object visitBindSelExpr(BindSelExpr bindSelExpr)
	{
		getPercurso().append("BindSelExpr\n");
		String[] result;
		String str = "";
		String name = ((String[])bindSelExpr.getName().accept(namePrint()))[0];
		str = str + name + ".";

		String strExprs[] = ((String[])bindSelExpr.getExpr().accept(this));
		result = new String[strExprs.length];
		result[0] = str + strExprs[0];
		for (int i=1; i <strExprs.length;i++ ) {
			result[i] = strExprs[i];
		}

		return result;
	}

	public Object visitBindExpr(BindExpr bindExpr)
	{
		getPercurso().append("BindExpr\n");

		String [] declarations = (String[])bindExpr.getDeclList().accept(declLisPrint());
		String[]  strdecl = this.returnDeclaracoes(declarations);

		String[] result = new String[strdecl.length];

		String str = "";
		if (!getUnicoded())
			str = "\\lblot" + Space + strdecl[0];
		else
			str = ZString.LBIND + Space + strdecl[0];

		result[0] = str;
		for (int i=1;i<strdecl.length;i++) {
			result[i] = strdecl[i];
		}

		str = Space;

		if(!getUnicoded())
			str = str +  "\\rblot";
		else 
			str = str + ZString.LBIND;

		result[result.length-1] += str;


		return result;
	}

	public Object visitChannelSet(ChannelSet term)
	{
		getPercurso().append("ChannelSetExpr\n");
		String[] result;
		result = (String[])((CircusChannelSet)term).getExpr().accept(this);

		return result;
	}


	public Object visitNameSet(NameSet term)
	{
		getPercurso().append("NameSetExpr\n");
		String[] result;

		result = (String [])((CircusNameSet)term).getExpr().accept(this);


		return result;
	}


	private String visit(Term term) {
		String result = "";

		if(term instanceof CircusAction) {
			result = treatString((String[])((CircusAction)term).accept(actionPrint()));
		}
		else if(term instanceof Expr) {
			result = treatString((String[])((Expr)term).accept(exprPrint()));
		}
		else if(term instanceof Pred) {
			result = treatString((String[])((Pred)term).accept(predPrint()));
		}
		else if(term instanceof Communication) {
			result = treatString((String[])((Communication)term).accept(communPrint()));
		}

		return result;
	}

	private String treatString(String[] strs) {
		String result = "";

		for(int i=0; i<strs.length; i++) {
			result = result + strs[i];
		}

		result = result.replaceAll(BRANCO, " ");

		return result;
	}

	public Object visitJokerNameSet(JokerNameSet term){
		getPercurso().append("JokerNameSet\n");
		String[] result = new String[1];
		result[0] = term.getName();
		return result;
	}

	public Object visitJokerChannelSet(JokerChannelSet term) {
		getPercurso().append("JokerNameSet\n");
		String[] result = new String[1];
		result[0] = term.getName();
		return result;
	}

	/**
	 * 
	 * @see net.sourceforge.czt.zpatt.visitor.JokerExprVisitor#visitJokerExpr(net.sourceforge.czt.zpatt.ast.JokerExpr)
	 */
	public Object visitJokerExpr(JokerExpr term) {
		getPercurso().append("JOker EXpr\n");
		String[] result = new String[1];
		result[0] = term.getName();

		return result;
	}

	public Object visitPredExpr(PredExpr predExpr) {
		getPercurso().append("PredExpr\n");
		String [] result = (String[])predExpr.getPred().accept(predPrint());

		return result;
	}

	public Object visitSchExprAction(SchExprAction term) {
		String[] result = (String[])term.accept(actionPrint());
		return result;
	}
}
