/*
 * CommunPrint.java
 *
 * Created on 13 de Setembro de 2005, 16:04
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package circusRefine.core.print;



import net.sourceforge.czt.z.ast.*;
import net.sourceforge.czt.circus.ast.*;
import net.sourceforge.czt.circus.visitor.*;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.circuspatt.ast.JokerCommunication;
import net.sourceforge.czt.circuspatt.visitor.JokerCommunicationVisitor;

/**
 *
 * @author comp
 */
public class CommunPrint
  extends Print
  implements CommunicationVisitor,
             FieldVisitor,
             DotFieldVisitor,
             InputFieldVisitor,
             JokerCommunicationVisitor{
  
  /** Creates a new instance of CommunPrint */
  public CommunPrint(Printer printer) {
    super(printer);
  }
  
  public Object visitCommunication(Communication term)
  {
	  String[] result = new String[1];
	  getPercurso().append("Comunication\n");
	  String str = ((String[])term.getChannelExpr().accept(exprPrint()))[0];
	  CircusFieldList cParams = term.getCircusFieldList();
	  for(Field cParam : cParams) {
		   String str2 =((String[])cParam.accept(this))[0];
		   str = str + str2;
	  }
	  
	  result[0] = str;

	  return result;
  }
  //ok
  public Object visitField(Field term)
  {
	  getPercurso().append("Field\n");
	  return term.accept(this);
  }
  //ok
  public Object visitDotField(DotField term)
  {
	  getPercurso().append("DotField\n");
	  String[] result = new String[1];

	  boolean hasOutPutAnn = false;
	  
	  /* Procura se existe anotação de !*/
	  for (Object obj : term.getAnns()){
		  if (obj instanceof OutputFieldAnn){
			  hasOutPutAnn = true;
		  }
	  }
	  
	  if (!hasOutPutAnn){
		  if (!getUnicoded())
			  result[0] = ".";
		  else
			  result[0] = ZString.DOT; 
	  }
	  else {
		  result[0] = ZString.OUTSTROKE + ((String[])term.getExpr().accept(exprPrint()))[0];
	  }
	  
	  if (term.getExpr() != null) {
		  
		  result[0] = result[0] + ((String[])term.getExpr().accept(exprPrint()))[0];
	  }
	  if (result[0].contains("minute, second")){
		  int k = 10;
	  }
	  return result;
  }
  //ok
  public Object visitInputField(InputField term)
  {
	  String[] result = new String[1];

	  getPercurso().append("InputField\n");
	  String name = ((String[])term.getVariableName().accept(namePrint()))[0];
	  

	  result[0] = ZString.INSTROKE + name;
	  Pred pred = term.getRestriction();
	  if(!(pred instanceof TruePred)) {
		  result[0] = result[0] + ":" + ((String[])pred.accept(predPrint()))[0];
	  }

	  return result;


  }

public Object visitJokerCommunication(JokerCommunication term) {
	getPercurso().append("JokerComunication\n");
	String[] result = new String[1];
	result[0] = term.getName();
	return result;
}

}
