package circusRefine.core.print;

import net.sourceforge.czt.circus.ast.ExtChoiceAction;
import net.sourceforge.czt.circus.ast.IntChoiceAction;
import net.sourceforge.czt.circus.ast.ParAction;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circus.visitor.ExtChoiceActionVisitor;
import net.sourceforge.czt.circus.visitor.IntChoiceActionVisitor;
import net.sourceforge.czt.circus.visitor.ParActionVisitor;
import net.sourceforge.czt.circus.visitor.SeqActionVisitor;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.circus.util.CircusString;

public class Action2Print 
	extends Print
	implements
	ExtChoiceActionVisitor,
	IntChoiceActionVisitor,
	SeqActionVisitor, 
	ParActionVisitor{

	/** Creates a new instance of ActionPrint */
	public Action2Print(Printer printer) {
		super(printer);
	}
	
	public Object visitExtChoiceAction (ExtChoiceAction term) {
		
		String[] result = new String[1];
		
		if (!getUnicoded()) {
			result[0] = "\\extchoice";
		}
		else{
			result[0] = CircusString.EXTCHOICE;
		}
		return result;
	}

	public Object visitIntChoiceAction (IntChoiceAction term) {
		String[] result = new String[1];
		
		if (!getUnicoded()) {
			result[0] = "\\intchoice";
		}
		else{
			result[0] = CircusString.INTCHOICE;
		}
		return result;
	}

	public Object visitSeqAction (SeqAction term) {
		String[] result = new String[1];
		
		if (!getUnicoded()) {
			result[0] = "\\circseq";
		}
		else{
			result[0] = CircusString.CIRCSEQ;
		}
		return result;	
	}

	public Object visitParAction(ParAction term) {
		return term.accept(parActionPrint());
	}

	
}