/*
 * Projeto: Circus Refine
 */
package circusRefine.core.opsdischarge.syntacticfunctions;

import java.util.HashSet;
import java.util.Set;

import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.ZName;

/**
 * Classe responsvel pela aplicao da funo DFV_Expr
 * 
 * @author Cristiano Castro
 */
public class UndashedFreeVariablesApplier 
extends SyntacticFunctionApplier<Expr, Expr>{
	
	/** Aplicador da funo FV_Expr */
	private FreeVariablesApplier fvApplier;
	
	/** Aplicador da funo DFV_Expr */
	private DashedFreeVariablesApplier dfvApplier;
	
	/**
	 * @return the fvApplier
	 */
	private FreeVariablesApplier getFvApplier() {
		return fvApplier;
	}

	/**
	 * @param fvApplier the fvApplier to set
	 */
	private void setFvApplier(FreeVariablesApplier fvApplier) {
		this.fvApplier = fvApplier;
	}

	/**
	 * @return the dfvApplier
	 */
	private DashedFreeVariablesApplier getDfvApplier() {
		return dfvApplier;
	}

	/**
	 * @param dfvApplier the dfvApplier to set
	 */
	private void setDfvApplier(DashedFreeVariablesApplier dfvApplier) {
		this.dfvApplier = dfvApplier;
	}

	/**
	 * Inicia o objeto informando os nomes que j foram alvo de 
	 * expanso no passo anterior do refinamento
	 * 
	 * @param termosExpandidos os termos que foram alvo de expanso no
	 *  passo anterior do desenvolvimento
	 * @see FreeVariablesApplier#FreeVariablesApplier(Set)
	 */
	public UndashedFreeVariablesApplier(Set<String> termosExpandidos) {
		this.setFvApplier(new FreeVariablesApplier(termosExpandidos));
		this.setDfvApplier(new DashedFreeVariablesApplier(termosExpandidos));
	}

	/**
	 * Aplica a funo Undashed Free Variables em um formato do tipo AST 
	 * de Circus
	 * 
	 * @param args a expresso a ser analisada
	 * @return o conjunto de expresses contendo o nome de variveis 
	 *  sem marca
	 */
	public Expr apply(Expr args) throws CannotEvaluateException {
		return this.transformarRepresentacaoConjuntoNomes(this.getUDFV(args));
	}
	
	/**
	 * Captura as variveis sem marca de uma expresso.
	 * 
	 * @param args a expresso a ser analisada
	 * @return o conjunto de nomes de variveis sem marca da expresso
	 */
	public HashSet<ZName> getUDFV(Expr args) throws CannotEvaluateException {
		HashSet<ZName> fv = this.getFvApplier().getFV(args);
		HashSet<ZName> dfv = this.getDfvApplier().getDFV(args);
		fv.removeAll(dfv);
		return fv;
	}
	
}
