/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.opsdischarge.syntacticfunctions;

import java.util.LinkedList;
import java.util.List;

import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.impl.ListTermImpl;
import net.sourceforge.czt.base.util.UnsupportedAstClassException;
import net.sourceforge.czt.circus.ast.CommPattern;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.Field;
import net.sourceforge.czt.circus.ast.InputField;
import net.sourceforge.czt.circus.visitor.CommunicationVisitor;
import net.sourceforge.czt.z.ast.ZName;

/**
 * Classe utilizada para aplicar a fun��o <i>inputVars</i>.
 * 
 * @author Cristiano Castro
 */
public class InputVarsApplier extends SyntacticFunctionApplier<Communication, 
	ListTerm<ZName>> {

	@Override
	/**
	 * Aplica a fun��o que captura as vari�veis livres no canal
	 */
	public ListTerm<ZName> apply(Communication arg) 
	throws CannotEvaluateException {
		List<ZName> list = this.getInputVars(arg);
		ListTerm<ZName> listTerm = new ListTermImpl<ZName>();
		
		listTerm.addAll(list);
		return listTerm;
	}

	/**
	 * Retorna as vari�veis de entrada de um canal
	 * 
	 * @param c o canal a ser analisado
	 * @return 
	 */
	public List<ZName> getInputVars(Communication c) 
	throws CannotEvaluateException {
		try {
			InputVarsVisitor visitor = new InputVarsVisitor();
			return c.accept(visitor);
		} catch (CannotEvaluateRunTimeException e) {
			throw new CannotEvaluateException(e);
		}
	}

	/**
	 * Visitor utilizado para aplicar fun��o sint�tica InputVars
	 * 
	 * @author Cristiano Castro
	 *
	 */
	protected class InputVarsVisitor implements 
	CommunicationVisitor<List<ZName>>{

		/**
		 * Visita a comunica��o argumento da fun��o <i>inputVars</i>
		 * 
		 * @param arg0 a comunica��o a ser visitada
		 * @param a lista com as vari�veis de entrada da comunica��o
		 */
		public List<ZName> visitCommunication(Communication arg0) {
			List<ZName> result = new LinkedList<ZName>();
			CommPattern tipoCanal = arg0.getCommPattern();
			/* Se o tipo do canal permitir vari�veis de entrada */
			if (tipoCanal.equals(CommPattern.Input) || 
					tipoCanal.equals(CommPattern.Mixed)) {
				try {
					for (Field field : arg0.getCircusFieldList()) {
						if (field instanceof InputField) {
							result.add(((InputField) field).getVariableZName());
						}
					}
				} catch (UnsupportedAstClassException e) {
					throw new CannotEvaluateRunTimeException(e);
				}
			}
			return result;
		}

	}

}
