/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.opsdischarge.syntacticfunctions;

/**
 * Excesso para ser disparada ao visitar um termo com a finalidade de
 * aplicar uma funo sinttica, caso o termo no possa ser avaliado
 * 
 * @author crisgc
 * @see CannotEvaluateException
 */
public class CannotEvaluateRunTimeException extends RuntimeException {

	/** Nmero para serializao */
	private static final long serialVersionUID = -4545566758790797218L;

	/**
	 * 
	 */
	public CannotEvaluateRunTimeException() {
		super();
	}

	/**
	 * @param message
	 * @param cause
	 */
	public CannotEvaluateRunTimeException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param message
	 */
	public CannotEvaluateRunTimeException(String message) {
		super(message);
	}

	/**
	 * @param cause
	 */
	public CannotEvaluateRunTimeException(Throwable cause) {
		super(cause);
	}

}
