/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.opsdischarge.setoperators;

import java.util.Set;

import net.sourceforge.czt.circus.ast.BasicChannelSetExpr;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.SetExpr;
import circusRefine.core.opsdischarge.NormalASTForComparisonGenerator;
import circusRefine.core.opsdischarge.syntacticfunctions.
CannotEvaluateException;
import circusRefine.core.print.Printer;

/**
 * Aplica a funo de pertinncia
 * 
 * @author Cristiano Castro
 *
 */
public class MembershipOperatorApplier {

	/**
	 * Aplica o operador de pertinncia
	 * 
	 * @param e o elemento a ser testado
	 * @param c o conjunto a ser testado
	 * @return <code>true</code> caso o elemento pertena ao conjunto
	 */
	public Boolean apply(Expr e, SetExpr c) throws CannotEvaluateException {
		Set<Expr> conj = OperadorBinarioConjuntos.transformarRepresentacao(c);

		/* Normaliza o argumento */
		e = (Expr) NormalASTForComparisonGenerator.gerarFormaNormal(e);

		boolean result = conj.contains(e);
		return result;
	}

	/**
	 * Aplica o operador de pertinncia
	 * 
	 * @param e o elemento a ser testado
	 * @param c o conjunto a ser testado
	 * @return <code>true</code> caso o elemento pertena ao conjunto
	 * @throws CannotEvaluateException caso o segundo argumento no 
	 *  for uma instncia de {@link SetExpr}
	 */
	public Boolean apply(Expr e, Expr c) throws CannotEvaluateException {
		try {
			if (c instanceof SetExpr) {
				return this.apply(e, (SetExpr) c);
			}
			else {
				return this.apply(e, (BasicChannelSetExpr) c);
			}
		} catch (ClassCastException exc) {
			throw new CannotEvaluateException(exc);
		}
	}

	/**
	 * Aplica o operador de pertinncia
	 * 
	 * @param e o elemento a ser testado
	 * @param c o conjunto de canais a ser testado
	 * @return <code>true</code> caso o elemento pertena ao conjunto
	 * @throws CannotEvaluateException caso o segundo argumento no 
	 *  for uma instncia de {@link SetExpr}
	 */
	public Boolean apply(Expr e, BasicChannelSetExpr c) throws CannotEvaluateException {
		Set<Expr> conj = OperadorBinarioConjuntos.transformarRepresentacao(c);
		
		/* Normaliza o argumento */
		e = (Expr) NormalASTForComparisonGenerator.gerarFormaNormal(e);
		
		String etxt = Printer.printLATTEX(e);
		String res = "";
		
		for (Expr expr : conj){
			res+= Printer.printLATTEX(expr) + " ";
		}
		
		boolean result = res.contains(etxt);
		return result;
	}

}
