/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.opsdischarge.setoperators;

import java.util.HashSet;

import circusRefine.core.opsdischarge.syntacticfunctions.CannotEvaluateException;

import net.sourceforge.czt.z.ast.Expr;

/**
 * Aplicador da funo Unio
 * 
 * @author Cristiano Castro
 */
public class CupApplier extends OperadorBinarioConjuntos<Expr> {

	/**
	 * Aplicador da funo unio.
	 * @param conj1 o primeiro parmetro da unio
	 * @param conj2 o segundo parmetro da unio
	 * @return a unio dos dois conjuntos
	 */
	public Expr apply(Expr conj1, Expr conj2) throws CannotEvaluateException {
		HashSet<Expr> c1 = CupApplier.transformarRepresentacao(conj1);
		HashSet<Expr> c2 = CupApplier.transformarRepresentacao(conj2);
		c1.addAll(c2);
		return CupApplier.tranformarRepresentacao(c1);
	}
	
}
