/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.opsdischarge;

import java.util.HashSet;

import circusRefine.core.util.ClonerVisitor;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.util.UnsupportedAstClassException;
import net.sourceforge.czt.circus.ast.CircusFieldList;
import net.sourceforge.czt.circus.ast.CommPattern;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.DotField;
import net.sourceforge.czt.circus.ast.Field;
import net.sourceforge.czt.z.ast.ConstDecl;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZSchText;

/**
 * Classe com alguns m�todos utilit�rios para a aplica��o de fun��es 
 * sint�ticas no CRefine
 * 
 * @author Cristiano Castro
 */
public final class SyntacticFunctionsUtils {

	/**
	 * Captura os nomes declarados no esquema
	 * 
	 * @param esquema o esquema a ser visitado
	 * @return os nomes declarados no esquema
	 * @throws UnsupportedAstClassException se a lista de 
	 * declara��es do esquema n�o for uma {@link ZDeclList}
	 * @see #variaveisDeclaradas(ZDeclList)
	 */
	public static HashSet<ZName> variaveisDeclaradas(ZSchText esquema) {
		return SyntacticFunctionsUtils.variaveisDeclaradas(
				esquema.getZDeclList());
	}
	
	/**
	 * M�todo utilit�rio para retirar todos os nomes declarados
	 * em uma lista de declara��es.
	 * 
	 * @param lista a lista de declara��es
	 * @return os nomes que foram declarados na lista de 
	 *  declara��es
	 * @see #variaveisDeclaradas(ZSchText)
	 */
	public static HashSet<ZName> variaveisDeclaradas(ZDeclList lista) {
		HashSet<Name> nomesDeclarados = new HashSet<Name>();
		
		/* Pesquisa os nomes declarados em uma lista de declara��es */
		for (Decl decl : lista) {
			if (decl instanceof VarDecl) {
				nomesDeclarados.addAll(((VarDecl) decl).getZNameList());
			} else if (decl instanceof ConstDecl) {
				nomesDeclarados.add(((ConstDecl) decl).getName());
			}
		}
		
		/* Monta a lista a retornar */
		HashSet<ZName> toReturn = new HashSet<ZName>();
		
		for (Name nome : nomesDeclarados) {
			if (nome instanceof ZName) {
				toReturn.add((ZName) nome);
			}
		}
		
		return toReturn;
	}
	
	/**
	 * M�todo utilizado para capturar todas as express�es de sa�da de 
	 * um canal.
	 * 
	 * @param c o canal a ser analisado
	 * @return o conjunto de express�es de sa�da do canal
	 * @throws UnsupportedAstClassException caso a lista de campos do
	 *  canal n�o seja uma {@link CircusFieldList}
	 */
	public static HashSet<Expr> expressoesSaidasCanal(Communication c) {
		HashSet<Expr> result = new HashSet<Expr>();
		if (c.getCommPattern().equals(CommPattern.Output) || 
				c.getCommPattern().equals(CommPattern.Mixed)) {
			for (Field campo : c.getCircusFieldList()) {
				if (campo instanceof DotField) {
					result.add(((DotField) campo).getExpr());
				}
			}
		}
		return result;
	}
	
	public static <T extends Term, U extends Term> HashSet<T> 
		subtracaoConjuntos(HashSet<T> c1, HashSet<U> c2) {
		HashSet<T> result = new HashSet<T>();
		HashSet<U> copiaC2 = new HashSet<U>();

		for (T termo : c1 ) {
			T copia = ClonerVisitor.cloneTermRemovingRelationsStack(termo);
			T normal = (T) 
				NormalASTForComparisonGenerator.gerarFormaNormal(copia);
			result.add(normal);
		}
		for (U termo : c2 ) {
			U copia = ClonerVisitor.cloneTermRemovingRelationsStack(termo);
			U normal = (U) 
				NormalASTForComparisonGenerator.gerarFormaNormal(copia);
			copiaC2.add(normal);
		}
		
		result.removeAll(copiaC2);
		return result;
		
		
		
	}
	
//	/**
//	 * <p>Testa se uma vari�vel marcada (<i>dashed</i>) � modificada 
//	 * segundo um determinado predicado de esquema. Uma vari�vel s� 
//	 * n�o � considerada modificada em um esquema </p>
//	 * 
//	 * @param predicado
//	 * @return
//	 */
//	public static Boolean isModified(ZName dashedVariables, Pred predicado) {
//		return false;
//	}

}
