/*
 * Projeto: Circus Refine
 */
package circusRefine.core.opsdischarge;

import java.util.Iterator;
import java.util.List;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.oz.ast.PredExpr;
import net.sourceforge.czt.oz.visitor.PredExprVisitor;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.BindExpr;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.Expr0N;
import net.sourceforge.czt.z.ast.Fact;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.NegPred;
import net.sourceforge.czt.z.ast.NumExpr;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZSchText;
import net.sourceforge.czt.z.visitor.ApplExprVisitor;
import net.sourceforge.czt.z.visitor.BindExprVisitor;
import net.sourceforge.czt.z.visitor.DeclVisitor;
import net.sourceforge.czt.z.visitor.Expr0NVisitor;
import net.sourceforge.czt.z.visitor.FactVisitor;
import net.sourceforge.czt.z.visitor.MemPredVisitor;
import net.sourceforge.czt.z.visitor.NegPredVisitor;
import net.sourceforge.czt.z.visitor.NumExprVisitor;
import net.sourceforge.czt.z.visitor.RefExprVisitor;
import net.sourceforge.czt.z.visitor.SchExprVisitor;
import net.sourceforge.czt.z.visitor.ZDeclListVisitor;
import net.sourceforge.czt.z.visitor.ZExprListVisitor;
import net.sourceforge.czt.z.visitor.ZSchTextVisitor;

/**
 * Classe utilizada para testar se uma Obrigao de Prova gerada pelo
 * CRefine. Esse passo da resoluo de OPs deve ser feito aps a 
 * expanso da mesma
 * 
 * @author Cristiano Castro
 */
public class CompatibilityTester implements TermVisitor<Boolean>, 
NegPredVisitor<Boolean>, FactVisitor<Boolean>, /*Pred2Visitor<Boolean>, */ 
MemPredVisitor<Boolean>, RefExprVisitor<Boolean>, ApplExprVisitor<Boolean>,
ZExprListVisitor<Boolean>, NumExprVisitor<Boolean>, Expr0NVisitor<Boolean>,
BindExprVisitor<Boolean>, ZDeclListVisitor<Boolean>, DeclVisitor<Boolean>,
PredExprVisitor<Boolean>, SchExprVisitor<Boolean>, ZSchTextVisitor<Boolean> 
{

	/**
	 * Mtodo utilitrio para testar se uma determinada OP pode ser
	 * analisada pelo CRefine. Poder ser analisada quer dizer que ela
	 * pode ser expandida para TENTAR testar se o seu valor  TRUE ou
	 * FALSE.
	 *  
	 * @param <T> o tipo do Predicado a ser passado
	 * @param op a obrigao de prova a ser testada
	 * @return <code>true</code> caso a OP pode ser expandida para 
	 * 	testar a sua compatibilidade, ou <code>false</code> caso
	 * 	contrrio 
	 */
	public static <T extends Pred> boolean test(T op, 
			List<String> funcoesTratados) {
		CompatibilityTester visitor = 
			new CompatibilityTester(funcoesTratados);
		return op.accept(visitor);
	}

	/** 
	 * Lista com os operadores que podem ser tratados de acordo com
	 * o tratador de OPs do CRefine 
	 */
//	private List<String> operadoresTrataveis;

	/**
	 * Lista das funes que so tratveis pelo CRefine
	 */
	private List<String> funcoesTrataveis;

	/**
	 * Inicia o teste de compatibilidade com os operadores tratveis 
	 * pelo gerenciador de OPs do CRefine
	 * 
	 * @param operadoresTrataveis a lista com os operadores que podem
	 *  ser tratados pelo CRefine
	 * @param funcoesTrataveis o mapeamento de funes que podem ser
	 *  tratadas pelo CRefine. O mapeamento  utilizado para indicar,
	 *  junto a cada funo, a quantidade de argumentos que ela possui.
	 * @param lhs o termo no qual a lei foi aplicada
	 * @param rhs o termo que foi construdo ao aplicar a lei
	 * @param astAntiga a ast que est no CRefine antes da aplicao
	 *  da lei 
	 */
	public CompatibilityTester(List<String> funcoesTrataveis) {
		//this.setOperadoresTrataveis(operadoresTrataveis);
		this.setFuncoesTrataveis(funcoesTrataveis);
	}

	/**
	 * @return the funcoesTrataveis
	 */
	private List<String> getFuncoesTrataveis() {
		return funcoesTrataveis;
	}

	/**
	 * @param funcoesTrataveis the funcoesTrataveis to set
	 */
	private void setFuncoesTrataveis(List<String> funcoesTrataveis) {
		this.funcoesTrataveis = funcoesTrataveis;
	}

	/**
	 * @return the operadoresTrataveis
	 */
//	private List<String> getOperadoresTrataveis() {
//		return operadoresTrataveis;
//	}

	/**
	 * @param operadoresTrataveis the operadoresTrataveis to set
	 */
//	private void setOperadoresTrataveis(List<String> operadoresTrataveis) {
//		this.operadoresTrataveis = operadoresTrataveis;
//	}

	/**
	 * Um termo genrico no pode ser tratado pelo CRefine
	 * 
	 * @param arg0 o termo a ser visitado
	 * @return <code>false</code> j que o termo no pode ser tratado
	 *  pelo manipulador de OPs do CRefine.
	 */
	public Boolean visitTerm(Term arg0) {
		return false;
	}

	/**
	 * Uma negao pode ser tratada se e somente se o seu argumento 
	 * puder ser tratado
	 * 
	 * @param arg0 a negao a ser visitado
	 * @return <code>true</code> caso o argumento da negao puder ser tratado
	 */
	public Boolean visitNegPred(NegPred arg0) {
		return arg0.getPred().accept(this);
	}

	/**
	 * Um predicado binrio (E, OU, SSE, IMPLICA) pode ser tratado se
	 * seus argumentos puderem ser tratados
	 * 
	 * @param arg0 o predicado binrio a ser visitado
	 * @return <code>true</code> caso os argumentos do Pred2 
	 *  puderem ser tratados ou <code>false</code> caso contrrio.
	 * 
	 */
//	public Boolean visitPred2(Pred2 arg0) {
//		return arg0.getLeftPred().accept(this) && 
//		arg0.getRightPred().accept(this);
//	}

	/**
	 * Um fato (Verdadeiro ou falso) pode ser tratado
	 * 
	 * @param arg0 o fato a ser visitado
	 * @return <code>true</code> pois o fato pode ser tratado
	 */
	public Boolean visitFact(Fact arg0) {
		return true;
	}

	/**
	 * Um predicado que pode conter funes como pertinncia, igualdade, 
	 * incluso. Verifica se tais aes pode ser tratadas 
	 * 
	 * @param arg0 o predicado com a relao a ser verificada
	 * @return <code>true</code> caso a relao e os argumentos do 
	 *  predicado puderem ser tratados, ou <code>false</code> caso
	 *  contrrio  
	 */
	public Boolean visitMemPred(MemPred arg0) {
		boolean result;
		if (!arg0.getMixfix()) {

			/* MemberShip Predicate */

			/* V se o conjunto st escrito "PorExtenso" */
			Expr conjunto = arg0.getRightExpr();
			result = conjunto instanceof SetExpr && 
			arg0.getLeftExpr().accept(this) && 
			conjunto.accept(this);

		} else if (arg0.getMixfix() && arg0.getRightExpr() instanceof SetExpr){

			/* Equality */
			result = arg0.getLeftExpr().accept(this) && 
			arg0.getRightExpr().accept(this);
		} else {

			/* Other operator application */
			RefExpr operator = (RefExpr)arg0.getRightExpr();
			ZName nomeOperador = operator.getZName();

			/* Retorna a string que identifica o operador */
			String strOperador = OPsDischargeUtils.getNomeReal(nomeOperador);

			/* Trata somente o subset */
			if (strOperador.equals(OPsDischargeUtils.getNomeReal(OPsDischargeUtils.SUBSETEQ))) {

				/* SUBSETEQ */

				/* Verifica se os argumentos so tratveis */
				ZExprList listaArgs = 
					((TupleExpr) arg0.getLeftExpr()).getZExprList();
				result = listaArgs.get(0) instanceof SetExpr && 
						 listaArgs.get(1) instanceof SetExpr && 
						 arg0.getLeftExpr().accept(this);
			} else {
				result = false;
			}

		}
		return result;
	}

	/**
	 * Mtodo utilizado para identificar se um determinado operador
	 * pode ser tratado segundo o tratador de OPs do CRefine
	 * 
	 * @param operador o nome do operador. Ex.: ZString.SUBSETEQ
	 * @return <code>true</code> caso o operador possa ser tratado 
	 *  pelo tratador de OPs do CRefine ou <code>false</code> caso
	 *  contrrio.
	 * @see #eTratavel(String, List)
	 * @see #eFuncaoTratavel(String)
	 */
//	private boolean eOperadorTratavel(String operador) {
//		return this.eTratavel(operador, this.getOperadoresTrataveis());
//	}

	/**
	 * Mtodo utilizado para identificar se um determinada funo
	 * pode ser tratada segundo o tratador de OPs do CRefine
	 * 
	 * @param operador o nome do operador. Ex.: ">", ZString.CAP, etc.
	 * @return <code>true</code> caso a funo possa ser tratada 
	 *  pelo tratador de OPs do CRefine ou <code>false</code> caso
	 *  contrrio.
	 * @see #eTratavel(String, List)
	 * @see #eOperadorTratavel(String)
	 */
	private boolean eFuncaoTratavel(String funcao) {
		return this.eTratavel(funcao, this.getFuncoesTrataveis());
	}

	/**
	 * Funo auxiliar para verificar de um determinada 
	 * funo/operao pode ser efetuada. Dada a lista de 
	 * funes/operadores tratveis
	 * 
	 * @param aTestar o nome da funo/operador a ser testado
	 * @param trataveis a lista de nomes tratveis
	 * @return <code>true</code> caso o nome puder ser tratado de 
	 *  acordo com a lista de operadores tratveis, ou 
	 *  <code>false</code> caso contrrio.
	 */
	private boolean eTratavel(String aTestar, Iterable<String> trataveis) {
		aTestar = OPsDischargeUtils.getNomeReal(aTestar);
		Iterator<String> itr = trataveis.iterator();
		boolean result = false;

		/* 
		 * Itera sobre a lista de operadores tratveis, enquanto no 
		 * tiver achado a resposta 
		 */
		while (itr.hasNext() && !result) {
			String operadorDaLista = OPsDischargeUtils.getNomeReal(itr.next());
			if (aTestar.equals(operadorDaLista)) {

				/* Est na lista! */
				result = true;
			}
		}

		return result;
	}

	/**
	 * Visita uma aplicao de funo, para verificar se a funo  
	 * compatvel com o CRefine
	 * 
	 * @param arg0 a aplicao de funo a ser visitada
	 * @return <code>true</code> caso a funo possa ser avaliada pelo CRefine 
	 *  ou <code>false</code> caso contrrio
	 */
	public Boolean visitApplExpr(ApplExpr arg0) {
		boolean result;

		/* Function Operator Application ou Application */
		if (arg0.getLeftExpr() instanceof RefExpr) {

			/*  uma funo */
			RefExpr funcao = (RefExpr)arg0.getLeftExpr();
			if (!funcao.getMixfix()) {

				/* Pode ser tratado */
				result = false;
				ZName nomeFuncao = funcao.getZName();
				String strFuncao = nomeFuncao.getWord();

				if (this.eFuncaoTratavel(strFuncao)) {

					/* 
					 * A funo  tratvel, confere se o nmero de 
					 * argumentos est de acordo com a especificao 
					 * da funo 
					 */
					int numArgsEspecificado = 
						this.getNumberOfArguments(strFuncao);
					int numArgs = 
						this.getNumberOfArguments(arg0.getRightExpr());

					if (numArgsEspecificado == numArgs) {

						/* 
						 * Nmero de argumentos da funo  igual ao 
						 * especificado 
						 */

						/* Confere se a lista de argumentos  tratvel */
						result = arg0.getRightExpr().accept(this);
					} else {

						/* 
						 * Nmero de argumentos difere do 
						 * especificado 
						 */
						result = false;
					}

				} else {

					/* A funo no  tratvel */
					result = false;
				}
			} else {

				/* O RefExpr no  uma referncia a uma funo */
				result = false;
			}
		} else {

			/* 
			 * O argumento da esquerda no  uma expresso de 
			 * funo 
			 */
			result = false;
		}
		return result;
	}

	/**
	 * Visita uma expresso de esquema. Visita o texto do esquema para
	 * ver se a lista de declaraes e o predicado  tratvel
	 * 
	 * @param arg0 a expresso a ser visitada
	 * @return <code>true</code> caso a lista de declaraes e o
	 *  predicado do esquema sejam tratveis
	 */
	public Boolean visitSchExpr(SchExpr arg0) {
		return arg0.getSchText().accept(this);
	}

	/**
	 * Visita um texto de esquema. Testa se a lista de declaraes e
	 * o predicado do esquema  tratvel
	 * 
	 * @param arg0 o texto do esquema a ser visitado
	 * @return <code>true</code> caso a lista de declaraes e o 
	 *  predicado sejam tratveis
	 */
	public Boolean visitZSchText(ZSchText arg0) {
		return arg0.getDeclList().accept(this) && arg0.getPred().accept(this);
	}

	/**
	 * Retorna o nmero de argumentos de uma funo caso esta seja 
	 * definida.
	 * 
	 * @param function o nome da funo a ser testada
	 * @return o nmero de argumentos da funo
	 * @throws NullPointerException caso a funo no esteja definida 
	 *  no mapeamento
	 */
	private int getNumberOfArguments(String function) {
		return OPsDischargeUtils.getNumberOfArguments(function);
	}

	/**
	 * Funo utilizada para retornar o nmero de argumentos que uma
	 * funo est recebendo.
	 * 
	 * @param expression o argumento da funo
	 * @return o nmero de argumentos
	 */
	private int getNumberOfArguments(Expr expression) {
		int result;
		if (expression instanceof TupleExpr) {
			TupleExpr args = (TupleExpr) expression;
			ZExprList listaArgs = args.getZExprList();
			result = listaArgs.size();
		} else {
			result = 1;
		}
		return result;
	}

	// TODO retirar esses comentrios de funes
//	/**
//	* Verifica se o argumento de uma funo est de acordo com sua
//	* especificao e assim, se pode ser tratado pelo CRefine
//	* 
//	* @param nomeFuncao o nome da funo a ser tratada
//	* @param argumento a expresso com o argumento da funo
//	* @return <code>true</code> caso o argumento da funo esteja de
//	*  acordo com sua especificao
//	*/
//	private boolean argumentoEstaCorreto(String nomeFuncao, Expr argumento) {
//	boolean eUmaAcao = (argumento.getAnn(ActionArgumentAnn.class) != null);
//	boolean result;

//	if (this.contem(OPsDischargeUtils.funcoesDeExpressoes(), nomeFuncao) ||
//	this.contem(OPsDischargeUtils.funcoesDeComunicacoes(), nomeFuncao)) 
//	{

//	/* Recebe uma expresso como argumento */
//	result = !eUmaAcao;
//	} else  if (this.contem(OPsDischargeUtils.funcoesDeEsquemas(), 
//	nomeFuncao)) {

//	/* 
//	* V se recebe um esquema como argumento, ou seja, 
//	* confere se no  uma ao, e, caso no seja, confere se
//	* seu argumento  um esquema ou uma possvel referncia a
//	* um esquema
//	*/
//	result = !eUmaAcao && ((argumento instanceof SchExpr) || 
//	(argumento instanceof RefExpr));
//	} else if (this.contem(OPsDischargeUtils.funcoesDeAcoes(), 
//	nomeFuncao)) {

//	/* Verifica se recebe uma ao como argumento */
//	result = eUmaAcao;
//	} else if (this.contem(OPsDischargeUtils.funcoesDeProcessos(), 
//	nomeFuncao)) {

//	/* 
//	* Testa se a funo recebe um nome como parmetro, que 
//	* pode ser de um possvel processo 
//	*/
//	result = !eUmaAcao && (argumento instanceof RefExpr);
//	} else {

//	result = false;
//	}
//	return result;
//	}

//	/**
//	* Mtodo utilitrio para testar se um determinada lista de 
//	* {@link String}s contm uma determinada funo
//	* 
//	* @param funcoes a lista de funes a ser testada
//	* @param funcao nome da funo a ser testada pelo CRefine
//	* @return um booleano indicado se a funo pertence ou no a 
//	*/
//	private boolean contem(List<String> funcoes, String funcao) {
//	List<String> funcoesSemArgTok = 
//	OPsDischargeUtils.funcoesSemArgTok(funcoes);
//	return funcoesSemArgTok.contains(funcao);
//	}

	/**
	 * Testa se o CRefine  capaz de tratar uma referncia. Verifica
	 * se o nome da referncia  conhecido. Em tese todas as referncias 
	 * podem ser tratadas
	 *
	 * @param arg0 a referncia a ser visitada
	 * @return <code>true</code>, j que toda referncia pode ser 
	 *  tratada
	 */
	public Boolean visitRefExpr(RefExpr arg0) {
		return true;
	}

	/**
	 * V se uma lista de expresses pode ser tratada segundo o
	 * tratador de OPs do CRefine
	 * 
	 * @param arg0 a lista de argumentos do CRefine
	 * @return <code>true</code> caso cada elemento da lista puder
	 *  ser tratado pelo CRefine. <code>false</code> caso contrrio.
	 */
	public Boolean visitZExprList(ZExprList arg0) {
		boolean result = true;
		Iterator<Expr> itr = arg0.iterator();

		/* 
		 * Itera sobre a lista para ver se todos os seus elementos 
		 * podem ser tratados 
		 */
		while (itr.hasNext() && result) {
			Expr aVisitar = itr.next();
			result = aVisitar.accept(this);
		}

		return result;
	}

	/**
	 * Um nmero obviamente pode ser tratado pelo CRefine.
	 * 
	 * @param arg0 a expresso do numeral a ser tratado
	 * @return <code>true</code> porque um numeral pode ser tratado
	 *  pelo CRefine 
	 */
	public Boolean visitNumExpr(NumExpr arg0) {
		return true;
	}

	/**
	 * Trata funes como {@link SetExpr} ou {@link TupleExpr}. 
	 * tratvel se a {@link ZExprList} for tratvel
	 * 
	 * @param arg0 a expresso a ser analisada
	 * @return <code>true</code> caso a lista de expresses puder ser
	 *  tratada. <code>false</code> caso contrrio.
	 */
	public Boolean visitExpr0N(Expr0N arg0) {
		return arg0.getExprList().accept(this);
	}

	/**
	 * Visita uma binding Expression.  vlida se sua lista de 
	 * declaraes for vlida
	 * 
	 * @param arg0 o argumento a visitar
	 * @return <code>true</code> caso sua lista de declaraes for
	 *  vlida. <code>false</code> caso contrrio
	 */
	public Boolean visitBindExpr(BindExpr arg0) {
		return arg0.getDeclList().accept(this);
	}

	/**
	 * Uma lista de declaraes  sempre vlida
	 * 
	 * @param arg0 a lista de declaraes a ser visitada
	 * @return <code>true</code> se cada declarao da lista de 
	 * 	declaraes for vlida 
	 */
	public Boolean visitZDeclList(ZDeclList arg0) {
		boolean result = true;

		/* Testa todas as declaraes em arg0 */
		for (Decl decl : arg0) {
			if (!decl.accept(this)) {

				/* No deu certo para uma declarao */
				result = false;
			}
		}

		/* Retorna true se todas as declaraes forem checadas */
		return result;
	}

	/**
	 * Uma declarao sempre  tratvel (por enquanto)
	 * 
	 * @param arg0 a declarao a ser visitada
	 * @return <code>true</code> pois uma declarao sempre  tratvel
	 */
	public Boolean visitDecl(Decl arg0) {
		return true;
	}

	/**
	 * Uma expresso booleana  tratvel se e somente se sua expresso
	 * for tratvel
	 * 
	 * @param arg0 o {@link PredExpr} a visitar
	 * @return <code>true</code> se o predicado puder ser tratado. 
	 *  <code>false</code> caso contrrio
	 */
	public Boolean visitPredExpr(PredExpr arg0) {
		return arg0.getPred().accept(this);
	}

}
