package circusRefine.core.idt;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import javax.swing.JOptionPane;


import circusRefine.core.print.Printer;
import circusRefine.core.util.ChildrenTermExtractor;
import circusRefine.core.util.TermoColetado;
import circusRefine.util.Identificador;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.rules.unification.ChildExtractor;
import net.sourceforge.czt.session.Markup;

/**
 * Classe utilitaria que contem diversos metodos estaticos uteis 
 * para insero, remoo, retorno do identificador
 * @author alessandro87
 *
 */
public class IdtUtils {

	public static boolean InsertIdt(Integer identificador, Term termo, Identificador id){

		/*
		 * Atribute que guarda se o termo em questao ja possui Idt, ou
		 * seja, ja foi alvo de aplicao de uma lei e consequentemente
		 * nao pode ser alvo.
		 */
		boolean jaIdt = haveIdt(termo, id);
		/*
		 * Insercao
		 */
		if (!jaIdt) {
			IdtAnn idtAnn = new IdtAnn(identificador, id);
			boolean b = termo.getAnns().add(idtAnn);
			return b;
		}
		return false;
	}

	public static boolean removeIdt (Term termo, Identificador idt) {
		for (Object ann : termo.getAnns()){
			if (ann instanceof IdtAnn) {
				if (((IdtAnn)ann).getWhich().equals(idt)) {
					boolean b = termo.getAnns().remove(ann);
					return b;
				}
			}
		}
		return false;
	}

	public static IdtAnn getId (Term termo, Identificador id) {
		for (Object ann : termo.getAnns()){
			if (ann instanceof IdtAnn) {
				if (((IdtAnn)ann).getWhich().equals(id)){
					return (IdtAnn)ann;
				}
			}
		}
		return null;
	}

	public static boolean haveIdt (Term termo, Identificador id) {
		boolean result = false;
		for (Object ann : termo.getAnns()){
			if (ann instanceof IdtAnn) {
				if (((IdtAnn)ann).getWhich().equals(id)){
					result = true;
				}
			}
		}
		return result;
	}

	public static void inserirIdtTermoColetado(Term term) {

		boolean b = haveIdt(term, Identificador.COLETANDO);
		/*
		 * Ja possui, entao incremento.
		 */
		if (b) {
			getId(term, Identificador.COLETANDO).incrIdt();
		}
		/*
		 * Insercao
		 */
		else {
			InsertIdt(1, term, Identificador.COLETANDO);
		}

		List<Term> termosFilhos = new ArrayList<Term>();

		termosFilhos = ChildrenTermExtractor.extrairFilhos(term);

		for (Term filho : termosFilhos) {
			inserirIdtTermoColetado(filho);
		}

	}

	public static void removeIdtTermoColetado (Term term) {

		boolean b = haveIdt(term, Identificador.COLETANDO);

		if (b) {
			IdtAnn id = IdtUtils.getId(term, Identificador.COLETANDO);
			int i = id.getIdt();
			if (i == 1) {
				id.decrIdt();
				//term.getAnns().remove(id);
			}
			else if ( i > 1) {
				id.decrIdt();
			}
		}


	}
	
	public static boolean haveCommentIdt (Term termo) {
		boolean result = false;
		for (Object ann : termo.getAnns()){
			if (ann instanceof IdtCommentAnn) {
				if (((IdtCommentAnn)ann).getWhich().equals(Identificador.COMENTARIO)){
					result = true;
				}
			}
		}
		return result;
	}
	/**
	 * Retorna o numero de identificadores de  comentario
	 * @param termo
	 * @return
	 */
	public static int numberCommentIdt (Term termo) {
		int result = 0;
		for (Object ann : termo.getAnns()){
			if (ann instanceof IdtCommentAnn) {
				if (((IdtCommentAnn)ann).getWhich().equals(Identificador.COMENTARIO)){
					result ++;
				}
			}
		}
		return result;
	}
	
	/* Esse metodo eh utilizado no docgenerator, ele reinicializa 
	 * o campo dos comentarios que indicam visita.
	 */
	public static void prepararComentarios(Term term) {
		LinkedList<IdtCommentAnn> lista = listIdtComments(term);
		for (IdtCommentAnn comIdt : lista){
			comIdt.setJaVisitado(false);
			comIdt.reatualizar();
		}
		List<Term> termosFilhos = new ArrayList<Term>();

		termosFilhos = ChildrenTermExtractor.extrairFilhos(term);

		for (Term filho : termosFilhos) {
			prepararComentarios(filho);
		}
		
		
	}
	
	public static LinkedList<IdtCommentAnn> listIdtComments(Term term) {
		LinkedList<IdtCommentAnn> result = new LinkedList<IdtCommentAnn>();
		if (haveIdt(term, Identificador.COMENTARIO)) {
			for (Object ann : term.getAnns()){
				if (ann instanceof IdtCommentAnn) {
					if (((IdtCommentAnn)ann).getWhich().equals(Identificador.COMENTARIO)){
						result.add((IdtCommentAnn)ann);
					}
				}
			}
		}
		return result;
	}
	
	public static void InsertCommentIdt(Term term, Integer idt) {
		
		int contador = IdtUtils.getContadorColect(term);
		IdtCommentAnn idtAnn = new IdtCommentAnn(idt,contador);
		term.getAnns().add(idtAnn);
		
	}
	
	public static int getContadorColect(Term term) {
		int result=0;
			if (IdtUtils.haveIdt(term, Identificador.COLETANDO)) {
				result = IdtUtils.getId(term, Identificador.COLETANDO).getIdt();
			}
		return result;
	}

	/**
	 * Metodo que pega todos os termos que foram comentados 
	 * dado um termo pai
	 * @param term
	 * @return
	 */
	public static LinkedList<Term> getListaDeTermosComentados(Term term, LinkedList<Term> result) {

		if (haveCommentIdt(term)){
			result.add(term);
		}

		List<Term> termosFilhos = ChildrenTermExtractor.extrairFilhos(term);

		for (Term filho : termosFilhos) {
			getListaDeTermosComentados(filho, result);
		}
		
		return result;
	}
	/**
	 * Realiza o decremento de algum identificador de termo
	 * @param termCom o Termo
	 * @param idt o tipo de Identificador
	 */
	public static void decrIdt(Term term, Identificador idt) {
		IdtAnn ann = getId(term, idt);
		ann.decrIdt();
	}
	

}
