/*
 * Projeto: Circus Refine
 */
package circusRefine.core.finder;

import java.util.List;

import circusRefine.core.util.ChildrenTermExtractor;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.impl.ListTermImpl;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.visitor.BasicProcessVisitor;

/**
 * Visitor utilizado para localizar {@link BasicProcess} em uma AST.
 * 
 * @author Cristiano Gurgel
 */
public class BasicProcessFinder implements TermVisitor<ListTerm<BasicProcess>>, 
		BasicProcessVisitor<ListTerm<BasicProcess>> {

	/**
	 * Lista os {@link BasicProcess} em uma AST.
	 * 
	 * @param termo a AST a ser visitada
	 * @return uma lista com os {@link BasicProcess} na AST.
	 */
	public static ListTerm<BasicProcess> listar(Term termo) {
		BasicProcessFinder finder = new BasicProcessFinder();
		return termo.accept(finder);
	}
	
	/** Construtor Padro */
	public BasicProcessFinder() { }
	
	/**
	 * Lista todos os {@link BasicProcess} em uma AST
	 * 
	 * @param termo raiz da AST
	 * @return a lista de todos os Basic Process na AST
	 */
	public ListTerm<BasicProcess> visitTerm(Term termo) {
		ChildrenTermExtractor extrator = new ChildrenTermExtractor();
		ListTerm<BasicProcess> result = new ListTermImpl<BasicProcess>();
		List<Term> filhos = termo.accept(extrator);
		
		/* Adiciona os BasicProcess */
		for (Term filho : filhos) {
			result.addAll(filho.accept(this));
		}
		return result;
	}

	/**
	 * Lista um {@link BasicProcess}
	 * 
	 * @param termo o {@link BasicProcess} a ser listado.
	 * @return uma lista contendo um nico elemento: o 
	 * 		{@link BasicProcess} passado como parmetro.
	 */
	public ListTerm<BasicProcess> visitBasicProcess(BasicProcess termo) {
		ListTerm<BasicProcess> result = new ListTermImpl<BasicProcess>();
		result.add(termo);
		return result;
	}

}
