/*
 * Cristiano Gurgel de Castro
 * 
 * Projeto: Circus Refine
 */
package circusRefine.core.finder;

import java.util.ArrayList;
import java.util.List;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.base.visitor.VisitorUtils;
import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.visitor.ActionParaVisitor;
import net.sourceforge.czt.z.ast.Para;

/* 
 * TODO verificar erro nesta classe
 * Não está capturando o ControllerInit do Buffer-refinement-leo.tex
 */
/**
 * Procura por {@link Para} na AST
 * 
 * @author Cristiano Gurgel
 * @version 20070423
 */
public class ActionParaFinder implements TermVisitor<List<ActionPara>>, 
		ActionParaVisitor<List<ActionPara>> {
	
	/**
	 * Retorna uma Lista com as {@link ActionPara} da AST
	 * 
	 * @param term a AST
	 * @return uma lista com as ações
	 */
	public static List<ActionPara> getActionsPara(Term term) {
		ActionParaFinder finder = new ActionParaFinder();
		return term.accept(finder);
	}
	
	/** Lista onde serão armazenados o resultado da busca */
	List<ActionPara> list;
	
	/**
	 * Inicia a lista de {@link Para}
	 */
	public ActionParaFinder() {
		this.setList(new ArrayList<ActionPara>());
	}
	
	/**
	 * Acessa a lista de acoes
	 * 
	 * @return a lista de acoes
	 */
	public List<ActionPara> getList() {
		return list;
	}

	/**
	 * Seta uma nova lista de acoes
	 * 
	 * @param list nova lista de acoes
	 */
	private void setList(List<ActionPara> list) {
		this.list = list;
	}
	
	/**
	 * Percorre recursivamente a AST
	 * 
	 * @param termo AST
	 * @return a Lista com as ActionPara encontradas na AST
	 */
	public List<ActionPara> visitTerm(Term termo) {
		VisitorUtils.visitTerm(this, termo);
		return this.getList();
	}
	
	/**
	 * Insere as {@link ActionPara} na lista
	 * 
	 * @param arg0 Action Para a ser visitada
	 * @return lista contendo a acao visitada
	 */
	public List<ActionPara> visitActionPara(ActionPara arg0) {
		this.getList().add(arg0);
		return this.getList();
	}
	
}
