package circusRefine.core.developments;

import circusRefine.core.ObrigacaoProva;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circus.ast.TransformerPred;
import net.sourceforge.czt.session.Markup;

/**
 * Classe que representa um subdesenvolvimento gerado a partir de 
 * uma obrigacao de prova de outro desenvolvimento
 * @author alessandro87
 *
 */
public class PODevelopmentTree extends DevelopmentTree {

	
	/** Obrigacao de Prova que gerou o subdesenvolvimento*/
	private ObrigacaoProva op;
	
	/** Indice do pai */
	private Integer pai;
	
	/** Tipo de Desenvolvimento que deve ser provado*/
	private Transformation tipo;
	
	/** Indice da Op na */
	private int idtOP;
	
	/** Termo onde se inicia a obrigao de prova*/
	private Term source;
	
	/** Termo que se deseja alcanar com a obrigao de prova*/
	private Term destination;
	
	/** Indica se o Subdesenvolvimento j atingiu sua meta*/
	private boolean proved;
	
	public PODevelopmentTree(String name, Markup markup2, Term programaOrigem, 
			Term programaFinal, 
			ObrigacaoProva opGeradora, Integer father, int identificador) {
		super(name, markup2, programaOrigem);
		
		idtOP = identificador;
		pai = father;
		source = programaOrigem;
		destination = programaFinal;
		op = opGeradora;
		tipo = pegarTipo();
		proved = false;
		
	}
	
	/**
	 * 
	 * @return o Tipo da Obrigacao de Prova
	 */
	private Transformation pegarTipo() {
		
		return ((TransformerPred)op.getPredicado()).getTransformation();
	}

	public Term getSource() {
		return source;
	}

	public int getPai() {
		return pai;
	}

	public void decrPai() {
		pai--;
	}

	public int getIdxOp() {
		return idtOP;
	}

	public ObrigacaoProva getOP() {
		return op;
	}

	public Term getTarget() {
		return destination;
	}
	
	public Transformation getTipo(){
		return tipo;
	}

	public boolean isProved() {
		return proved;
	}

	public void proved() {
		this.proved = true;
	}

	public void notProved() {
		this.proved = false;
		
	}

}
