package circusRefine.core.developments;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;

import javax.swing.JOptionPane;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.session.Markup;

import circusRefine.core.ExternalManager;
import circusRefine.core.LoadAnswer;
import circusRefine.core.NoPrograma;
import circusRefine.core.ObrigacaoProva;
import circusRefine.core.relations.RelationsAnn;
import circusRefine.core.storage.AdicaoComentario;
import circusRefine.core.storage.CarregamentoEspecificacao;
import circusRefine.core.storage.CarregamentoSubDesenvolvimento;
import circusRefine.core.storage.StepOfExecution;
import circusRefine.core.storage.SubDesenvolvimento;
import circusRefine.core.storage.ToSave;
import circusRefine.core.util.SelectionTermVisitor;
import circusRefine.gui.Comentario;

/**
 * Classe gerenciadora dos mais diversos desenvolvimentos
 * @author alessandro87
 *
 */
public class DevelopmentsManager {

	/** Lista de Desenvolvimentos*/
	private ArrayList<DevelopmentTree> desenvolvimentos;


	/** Referencia para o Gerenciador Externo, o gerenciador mais importante*/
	private ExternalManager gerInterface;

	public DevelopmentsManager(ExternalManager gerExterno) {
		desenvolvimentos = new ArrayList<DevelopmentTree>();
		gerInterface = gerExterno;
	}


	/**
	 * Insere um desenvolvimento a partir de um 
	 * evento de Novo da TelaPrincipal  
	 * @return indicador do ultimo desenvolvimento
	 */
	public int inserirNovoDesenvolvimento(String name, Markup markup, LoadAnswer resposta) {

		DevelopmentTree development = new DevelopmentTree(name, markup
				, resposta.getProgramaCarregado());


		CarregamentoEspecificacao step = 
			new CarregamentoEspecificacao(resposta.getEspecificacao(),markup);

		desenvolvimentos.add(development);
		development.adicionarHistorico(step);
		return desenvolvimentos.size() -1;

	}

	public DevelopmentTree getDevelopment(int id) {
		return desenvolvimentos.get(id);
	}

	/**
	 * Remove o desenvolvimento indexado por tabNumber
	 * @param tabNumber desenvolvimento a ser removido
	 */
	public void removeDevelopment(int tabNumber) {
		/* Desenvolvimento possuis Filhos*/
		if (this.getDevelopment(tabNumber).getChildrenCount() > 0) {
			this.getDevelopment(tabNumber).removendo();
			while (this.getDevelopment(tabNumber).getChildrenCount() > 0) {
				gerInterface.closeTab(this.getDevelopment(tabNumber).getChildAt(0));
			}
		}
		/* E um filho*/
		if (this.getDevelopment(tabNumber) instanceof PODevelopmentTree){
			
			int pai = ((PODevelopmentTree)this.getDevelopment(tabNumber)).getPai();
			if (!this.getDevelopment(pai).estaSendoRemovido()) {
				/* E necessario guard�-lo como filho oculto*/
			PODevelopmentTree filhoOculto = (PODevelopmentTree)this.getDevelopment(tabNumber);
				this.getDevelopment(pai).adicionarFilhoOculto(filhoOculto);
			}
			this.getDevelopment(pai).removerFilho(tabNumber);
			
		}
		for (int i = tabNumber+1; i< desenvolvimentos.size();i++){
			/* E Pai*/
			if (desenvolvimentos.get(i).getChildrenCount() > 0){
				desenvolvimentos.get(i).dcrFilhos();
			}
			if (desenvolvimentos.get(i) instanceof PODevelopmentTree){
				if ( ((PODevelopmentTree)desenvolvimentos.get(i)).getPai() > tabNumber){
					((PODevelopmentTree)desenvolvimentos.get(i)).decrPai();
				}
				/*decrementar filhos a partir do indice*/
				else{
					int pai = ((PODevelopmentTree)desenvolvimentos.get(i)).getPai();
					desenvolvimentos.get(pai).dcrFilhos(i);
				}
			}
		}
		this.desenvolvimentos.remove(tabNumber);
	}

	/**
	 * Retorna o termo que compreende a linha inicial linhaI e a linha final 
	 * linhaF e cujo desenvolvimento � indexado por idt
	 * @param idt indice do desenvolvimento
	 * @param linhaI linha inicial
	 * @param linhaF linha final
	 * @return termo
	 */
	public NoPrograma retornarProgSelecionado(int idt, int linhaI, int linhaF) {
		/* Resposta da funcao */
		NoPrograma toReturn;

		/* Visitor para selecionar o termo */
		SelectionTermVisitor seleciona = 
			new SelectionTermVisitor(new RelationsAnn(linhaI, linhaF));

		if (this.getDevelopment(idt).getProgAtual() != null) {

			/* O programa do gerenciador nao esta vazio */
			Term result = this.getDevelopment(idt).getProgAtual().accept(seleciona);
			result = gerInterface.wrapForTransformer(result);
			toReturn = new NoPrograma(result, linhaI, linhaF);
		}
		else {
			toReturn = null;
		}

		return toReturn;
	}


	/**
	 * Atualiza o texto do comentario editado
	 * @param comment comentario editado
	 * @param selectedDevelopment indice do desenvolvimento utilizado
	 */
	public void editarComentarioEmHistorico(Comentario comment, int selectedDevelopment) {
		LinkedList<StepOfExecution> history = this
		.getDevelopment(selectedDevelopment).getPassos().getHistorico();
		for (StepOfExecution exec :  history) {
			if (exec instanceof AdicaoComentario) {
				if (  ((AdicaoComentario)exec).getIdentificador() == 
					comment.getIdentificador()) {
					((AdicaoComentario)exec).setComentario(comment.getTexto());
				}
			}
		}
	}


	public int getSize() {
		return desenvolvimentos.size();
	}


	/**
	 * 
	 * @param string nome do desenvolvimento pai
	 * @param subDev Subdesenvolvimento a ser inserido
	 * @return o indice da posição de inserção do subdesenvolvimento inserido
	 */
	public int inserirNovoSubdesenvolvimento(String string, PODevelopmentTree subDev, int indexPai, String nomePai) {

		CarregamentoSubDesenvolvimento step = 
			new CarregamentoSubDesenvolvimento(subDev.getIdxOp());
		desenvolvimentos.add(subDev);
		step.setNomePai(nomePai);
		subDev.adicionarHistorico(step);

		adicionarFilho(indexPai, desenvolvimentos.size() -1);

		return desenvolvimentos.size() -1;
	}
	
	


	/**
	 * Adiciona o Filho indexado por i ao pai indexado por indexPai 
	 * @param indexPai indice do Desenvolvimento do Pai
	 * @param i indice do Desenvolvimento do Filho
	 */
	private void adicionarFilho(int indexPai, int i) {
		desenvolvimentos.get(indexPai).adicionarFilho(i);
	}


	/**
	 * Pega os subdesenvolvimentos de um dado desenvolvimento i e 
	 * insere seus passos na lista de historico do desenvolvimento i
	 * atraves do passo de execu��o SubDesenvolvimento
	 * @param i indice do desenvolvimento
	 * @param arquivo Arquivo o qual obterá o path para salvar os filhos.
	 * @throws IOException 
	 */
//	public void inserirSubDesenvolvimentoHistorico(int i, File arquivo){
//		if (desenvolvimentos.get(i).hasChildren() || desenvolvimentos.get(i).hasHiddenChild()){
//			/** Filhos Abertos*/
//			for (int j=0; j< desenvolvimentos.get(i).getChildrenCount(); j++) {
//				int filho = desenvolvimentos.get(i).getChildAt(j);
//				PODevelopmentTree subdesenvolvimento = (PODevelopmentTree)desenvolvimentos.get(filho);
//				SubDesenvolvimento subHist = 
//					new SubDesenvolvimento(subdesenvolvimento.getPassos().getHistorico());
//				
//				String path = arquivo.getParent();
//				path = path + subdesenvolvimento.getNome();
//				ToSave passos = subdesenvolvimento.getPassos();
//				
//				File suBDeveFile = new File(path);
//				
//				try {
//					gerInterface.getGerInterno().salvar(suBDeveFile, passos);
//				} catch (IOException e) {
//					// TODO Auto-generated catch block
//					e.printStackTrace();
//				}
//				
//				System.out.println("SALVEI");
//				desenvolvimentos.get(i).adicionarHistorico(subHist);
//			}
//			/** Filhos Ocultos */
//			for (int k=0; k< desenvolvimentos.get(i).getHiddenChildrenCount();k++){
//				PODevelopmentTree subDev = (this.getDevelopment(i)).getFilhoOculto(k);
//				SubDesenvolvimento subHist = 
//					new SubDesenvolvimento(subDev.getPassos().getHistorico());
//				desenvolvimentos.get(i).adicionarHistorico(subHist);
//			}
//			
//		}
//	}
	
	public void inserirSubDesenvolvimentoHistorico(int i, File arquivo) {
		if (desenvolvimentos.get(i).hasChildren() || desenvolvimentos.get(i).hasHiddenChild()){
			/** Filhos Abertos*/
			for (int j=0; j< desenvolvimentos.get(i).getChildrenCount(); j++) {
				int filho = desenvolvimentos.get(i).getChildAt(j);
				PODevelopmentTree subdesenvolvimento = (PODevelopmentTree)desenvolvimentos.get(filho);
				
				/** Guardando o nome do desenvolvimento do pai no filho*/
				CarregamentoSubDesenvolvimento step = (CarregamentoSubDesenvolvimento)
				subdesenvolvimento.getPassos().getHistorico().get(0);
				
				step.setNomePai(arquivo.getName().substring(0, arquivo.getName().length() - 4));
				
				/** Adicionando o SubDesenvolvimento no pai*/
				
				SubDesenvolvimento subHist = 
					new SubDesenvolvimento(subdesenvolvimento.getPassos().getHistorico());
				desenvolvimentos.get(i).adicionarHistorico(subHist);
			}
			/** Filhos Ocultos */
			for (int k=0; k< desenvolvimentos.get(i).getHiddenChildrenCount();k++){
				PODevelopmentTree subDev = (this.getDevelopment(i)).getFilhoOculto(k);
				/** Guardando o nome do desenvolvimento do pai no filho*/
				CarregamentoSubDesenvolvimento step = (CarregamentoSubDesenvolvimento)
				subDev.getPassos().getHistorico().get(0);
				
				step.setNomePai(arquivo.getName().substring(0, arquivo.getName().length() - 4));
				
				/** Adicionando o SubDesenvolvimento no pai*/
				SubDesenvolvimento subHist = 
					new SubDesenvolvimento(subDev.getPassos().getHistorico());
				desenvolvimentos.get(i).adicionarHistorico(subHist);
			}
			
		}
	}


	public boolean verificarFilho(int id) {
		if (desenvolvimentos.get(id) instanceof PODevelopmentTree){
			return true;
		}
		return false;
	}

	/**
	 * 
	 * @param index
	 * @param opSelecionada
	 * @param identificador
	 * @return O subdesenvolvimento armazenado no desenvolvimento indexado por index,
	 * cuja origem designa a obriga��o de prova opSelecionada, identificada por identificador
	 */
	public PODevelopmentTree getSubDesenvolvimentoOculto(int index, ObrigacaoProva opSelecionada, int identificador) {
		
		PODevelopmentTree result;
		
		result = this.getDevelopment(index).getFilhoOculto (identificador, opSelecionada);
		
		return result;
	}

	
	/**
	 * 
	 * @param identificador
	 * @param opSelecionada
	 * @param indexPai
	 * @return -1 indicando se o subdesenvolvimento nao est� aberto e 
	 * o id do subdesenvolvimento caso contrario
	 */
	public int estaAbertoSubDev(int identificador, ObrigacaoProva opSelecionada, int indexPai) {
		int result = -1;
		for (int i= indexPai + 1; i < desenvolvimentos.size() ; i++){
			if (desenvolvimentos.get(i) instanceof PODevelopmentTree) {
				if (((PODevelopmentTree)desenvolvimentos.get(i)).getPai() == indexPai) {
					if (((PODevelopmentTree)desenvolvimentos.get(i)).getIdxOp() == identificador){
						return i;
					}
				}
			}
		}
		
		return result;
	}

	/**
	 * 
	 * @return O termo target do subdesenvolvimento indexado por i
	 */
	public Term getTarget(int i) {
		return ((PODevelopmentTree)this.desenvolvimentos.get(i)).getTarget();
	}


	/**
	 * Remove o recem inserido passo de SubDesenvolvimento de um Desenvolvimento
	 * que foi recentemente salvo;
	 * @param selectedDevelopment
	 */
	public void removerPassoSubDesenvolvimento(int selectedDevelopment) {
		DevelopmentTree dev = this.getDevelopment(selectedDevelopment);
		LinkedList<SubDesenvolvimento> aRemover = new LinkedList<SubDesenvolvimento>();
		for (StepOfExecution passo : dev.getPassos().getHistorico()){
			if (passo instanceof SubDesenvolvimento){
				aRemover.add((SubDesenvolvimento)passo);
			}
		}
		
		for (SubDesenvolvimento a : aRemover) {
			dev.getPassos().getHistorico().remove(a);
		}
	}







}
