package circusRefine.core.developments;

import java.util.LinkedList;
import java.util.Stack;



import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.session.Markup;
import circusRefine.Tactic.Util.TacticAnswer;
import circusRefine.core.ExternalManagerStacks;
import circusRefine.core.LawAnswer;
import circusRefine.core.ObrigacaoProva;
import circusRefine.core.relations.RelationRowLaw;
import circusRefine.core.storage.StepOfExecution;
import circusRefine.core.storage.ToSave;
import circusRefine.core.util.TermoColetado;
import circusRefine.gui.stacks.TelaPrincipalStacks;

/**
 * Classe que contem os atributos para identificar e caracterizar um 
 * Desenvolvimento
 * @author alessandro87
 *
 */
public class DevelopmentTree {


	/**
	 * Construtor
	 * @param name path e nome
	 * @param markup2 formato
	 * @param programaCarregado termo
	 */
	public DevelopmentTree( String name, Markup markup2, Term programaCarregado) {
		markUP = markup2;
		currentAST = programaCarregado;

		/** Capturando o nome a partir do path*/
		nome = name;
		if (nome.contains(".xml") || nome.contains(".tex")) {
			if (!nome.endsWith("~")) {
				nome = nome.substring(0, nome.length() -4); //retirando formato .xml ou .tex
			}
			else {
				nome = nome.substring(0, nome.length() -5);
			}
		}

		undoStack = new Stack<Term>();
		redoStack = new Stack<Term>();
		pilhas = new ExternalManagerStacks();
		pilhasP =  new TelaPrincipalStacks();

		pilhaTaticasRedo = new Stack<Term>();
		pilhaTaticasUndo = new Stack<Term>();

		passos = new ToSave();
		filhos = new LinkedList<Integer>();
		filhosOcultos = new LinkedList<PODevelopmentTree>();
		beingRemoved = false;

		/**
		 * Responsavel por determinar a quantidade de apliccoes de
		 * leis e taticas
		 */
		pilhaAplicacao = new Stack<Integer>();

	}



	/**
	 * ATRIBUTOS EXTERNOS
	 */

	/** Nome do arquivo xml ou tex utilizado para iniciar o refinamento*/
	private String nome;


	/** Indica em qual formato o desenvolvimento est� sendo exibido*/
	private Markup markUP;


	/** S�rie de pilhas utilizadas no Gerenciodor Externo*/
	private ExternalManagerStacks pilhas;
	private TelaPrincipalStacks pilhasP;

	/**
	 * ATRIBUTOS INTERNOS
	 */

	/** Programa atual tratado pela ferramenta */
	private Term currentAST;

	/** Pilha onde s�o guardadas as ASTs para o undo */
	private Stack<Term> undoStack;

	/** Pilha onde s�o guardadas as ASTs para o redo */
	private Stack<Term> redoStack;

	/**
	 * Criando uma nova pilha para armazenar as AST´s 
	 * após a aplicação de uma tática
	 */

	private Stack<Term> pilhaTaticasRedo; 

	private Stack<Integer> pilhaAplicacao;

	public Stack<Integer> getPilhaAplicacao() {
		return pilhaAplicacao;
	}

	private Stack<Term> pilhaTaticasUndo;


	public void setPilhaAplicacao(Stack<Integer> pilhaAplicacao) {
		this.pilhaAplicacao = pilhaAplicacao;
	}

	public Stack<Term> getPilhaTaticasRedo() {
		return pilhaTaticasRedo;
	}

	public void atualizarPilhaAplicacao(int aplicacao){

		this.pilhaAplicacao.push(aplicacao);
	}

	public int retornarPilhaAplicacao(){

		if (this.pilhaAplicacao.size() == 0)
			return -1;
		else return this.pilhaAplicacao.pop();
	}

	public int retornarPilhaUndo(){

		if (this.pilhaAplicacao.size() == 0)
			return -1;
		else return this.pilhaAplicacao.pop();
	}
	
	
	public int retornarPilhaRedo(){

		if (this.pilhaTaticasRedo.size() == 0)
			return -1;
		else return this.pilhaAplicacao.pop();
	}


	/**
	 * Método que atualiza a pilha de táticas
	 * @param newAst AST a ser adicionada na pilha de Táticas
	 */
	public void atulizarPilhaTaticas(Term newAst){

		pilhaTaticasUndo.push(newAst);
		//antes era o Redo ver


	}

	public boolean verificarPilhaUndo(){

		if (pilhaTaticasUndo.size() > 0)
			return true;
		return false;
	}


	/**
	 * Método que retornar a AST corrente
	 * @return AST
	 */
	public Term getCurrentAST(){

		return currentAST;
	}

	/** Passos da execu��o de um refinamento */
	private ToSave passos;

	/** 
	 * ATRIBUTOS PARA GERENCIAR SUBDESENVOLVIMENTOS
	 * */

	/** Lista de indices dos Filhos do Desenvolvimento*/
	private LinkedList<Integer> filhos;

	/** Booleano auxiliar que indica se um desenvolvimento esta ou 
	 * nao sendo removido*/
	private boolean beingRemoved = false;

	private LinkedList<PODevelopmentTree> filhosOcultos;

	/**
	 * 
	 * @param 
	 */
	public void adicionarHistorico(StepOfExecution step) {
		this.passos.addStep(step);
	}

	/**
	 * 
	 * @return Programa Atual
	 */
	public Term getProgAtual() {
		return currentAST;
	}

	/**
	 * 
	 * @return nome do desenvolvimento
	 */
	public String getNome() {
		return nome;
	}

	public int getSizeOfHistorico() {
		return passos.getHistorico().size();
	}

	public int getSizeOfRedoHistorico() {
		return passos.getRedoList().size();
	}


	/**
	 * Atualiza o programa com o novo, colocando o atual, no topo da
	 * pilha de undo 
	 * 
	 * @param novoPrograma o novo programa
	 */
	public void atualizarPrograma(Term novoPrograma) {
		this.undoStack.push(this.currentAST);
		currentAST = novoPrograma;

		/* Limpa a pilha de Redo */
		if (!redoStack.isEmpty()) {
			redoStack.clear();
		}
	}

	/**
	 * Atualiza o programa com o novo, colocando o atual, no topo da
	 * pilha de undo 
	 * 
	 * @param novoPrograma o novo programa
	 */
	public void atualizarProgramaTatica(Term novoPrograma) {
		this.pilhaTaticasUndo.push(this.currentAST);
		currentAST = novoPrograma;

		/* Limpa a pilha de Redo */
		if (!pilhaTaticasRedo.isEmpty()) {
			pilhaTaticasRedo.clear();
		}
	}

	public Stack<Term> getTermosAplicados() {
		return pilhas.getTermosApl();
	}
	public Stack<Term> getRedoTermosAplicados() {
		return pilhas.getRedoTermosApl();
	}

	public Stack<LawAnswer> getRespostasLeis(){
		return pilhas.getRespostaLeis();
	}
	public Stack<LawAnswer> getRedoRespostasLeis() {
		return pilhas.getRedoRespostaLeis();
	}
	public Stack<RelationRowLaw> retornarRedoPilhaDeLeis() {
		return this.pilhas.getRedoleisApl();
	}
	
	
	public Stack<RelationRowLaw> retornarRedoPilhaDeTaticas() {
		return this.pilhas.getRedoTaticasApl();
	}

	/**
	 * Metodo que retorna a pilha que armazena as leis que foram utilizadas
	 * @return leiAplicas
	 */
	public Stack<RelationRowLaw> retornarPilhaDeLeis () {
		return this.pilhas.getLeisApl();
	}

	/**
	 * Metodo que retorna a pilha que armazena as táticas que foram utilizadas
	 * @return tacAplicadas
	 */
	public Stack<RelationRowLaw> retornarPilhaDeTaticas () {
		return this.pilhas.getTaticaApl();
	}

	/**
	 * Metodo que retorna a lei mais recentemente utilizada
	 * @return
	 */
	public RelationRowLaw retornarTopoLei() {
		return this.retornarPilhaDeLeis().peek();
	}

	/**
	 * Metodo que retorna a tatica mais recentemente utilizada
	 * @return
	 */
	public RelationRowLaw retornarTopoTatica() {
		return this.retornarPilhaDeTaticas().peek();
	}

	public RelationRowLaw retornarRedoTopoLei () {
		return this.retornarRedoPilhaDeLeis().peek();
	}
	
	public RelationRowLaw retornarRedoTopoTatica () {
		return this.retornarRedoPilhaDeLeis().peek();
	}


	public ToSave getPassos() {
		return passos;

	}


	/**
	 * 
	 * @return A pilha de acaoes Coletadas a serem desfeitas
	 */
	public Stack<TermoColetado> getUndoAcoesColetadas () {
		return pilhasP.getUndoAcoesColetadas();
	}



	/**
	 * 
	 * @return A pilha de acaoes coletadas a serem refeitas
	 */
	public Stack<TermoColetado> getRedoAcoesColetadas () {
		return pilhasP.getRedoAcoesColetadas();
	}
	/**
	 * Metodo utilizado para esvaziar as pilhas do undo e redo quando um novo programa sera carregado
	 */
	public void esvaziarPilhasP() {

		this.pilhasP.esvaziarPilhas();

	}

	/**
	 * Esvazia estruturas de Redo
	 *
	 */
	public void esvaziarRedo() {
		this.passos.getRedoList().clear();
		this.pilhas.esvaziarRedoPilhas();
		this.pilhasP.esvaziarRedoPilhas();

	}

	/**
	 * Esvazia estruturas de Undo
	 *
	 */
	public void esvaziarUndo() {
		this.pilhas.esvaziarPilhas();
		this.pilhasP.esvaziarPilhas();
	}

	/**
	 * 
	 * @return O ultimo passo de execu��o do Programa
	 */
	public StepOfExecution getLastAction() {
		return passos.getHistorico().getLast();
	}

	/**
	 * 
	 * @return O ultimo passo de execu��o do Programa da lista Redo
	 */
	public StepOfExecution getRedoLastAction() {
		return passos.getRedoList().getLast();
	}

	/**
	 * Desfaz internamente o �ltimo passo
	 *
	 */
	public void desfazerPasso() {
		this.passos.desfazer();
	}

	/**
	 * Refaz internamente o �ltimo passo
	 *
	 */
	public void refazerPasso() {
		this.passos.refazer();
	}


	/**
	 * desfaz a a��o anterior do programa
	 * 
	 * @return true caso a a��o for desfeita com sucesso e false 
	 * 		   caso a a��o n�o possa ser desfeita
	 */
	public boolean desfazerInterno() {
		if (!(this.undoStack.isEmpty())) { /* executa a a��o de desfazer */ 

			/* empilha na lista de refazer */
			this.redoStack.push(this.currentAST);

			/* Modifica o programa atual */
			currentAST = this.undoStack.pop();

			/* desfazer realizado */
			return true;
		} else {

			/* desfazer nao realizado */
			return false;
		}
	}


	/**
	 * Metodo responsavel por desfazer uma tatica
	 * 
	 * @return true caso a acao for desfeita com sucesso e false 
	 * 		   caso a acao nao possa ser desfeita
	 */
	public boolean desfazerInternoTatica() {
		if (!(this.pilhaTaticasUndo.isEmpty())) { /* executa a a��o de desfazer */ 

			/* empilha na lista de refazer */
			this.pilhaTaticasRedo.push(this.currentAST);

			/* Modifica o programa atual */
			currentAST = this.pilhaTaticasUndo.pop();


			/* desfazer realizado */
			return true;
		} else {

			/* desfazer nao realizado */
			return false;
		}
	}

	/**
	 * Desfaz as Pilhas de Lei e as pilhas de Termos Aplicados 
	 */
	public void desfazerPilhas() {
		if (!pilhas.getLeisApl().isEmpty()) {
			this.pilhas.getRedoleisApl().add(pilhas.getLeisApl().pop());
		}
		this.getRedoTermosAplicados().push(this.getTermosAplicados().pop());
		this.pilhas.getRedoRespostaLeis().push(pilhas.getRespostaLeis().pop());
	}

	/**
	 * 
	 * @return booleano indicando se a lista de redo est� vazia
	 */
	public boolean isRedoHistoricoEmpty() {
		return passos.getRedoList().isEmpty();
	}


	/**
	 * refaz a a��o do programa	
	 * 
	 * @return true caso a a��o for refeita e false caso a a��o n�o
	 * 		   possa ser refeita
	 */
	public boolean refazerInterno() {

		if (!this.passos.getRedoList().isEmpty()) { /* executa a a��o de refazer */

			/* empilha na lista de desfazer */
			this.undoStack.push(currentAST);

			/* Atualiza a AST */
			currentAST = (this.redoStack.pop());
			/* refazer realizado */
			return true;
		} else {
			/* refazer nao realizado */
			return false;
		}

	}
	
	
	/**
	 * refaz a acao do Tatica
	 * 
	 * @return true caso a acao for refeita e false caso a a��o n�o
	 * 		   possa ser refeita
	 */
	public boolean refazerInternoTatica() {

		if (!(this.pilhaTaticasRedo.isEmpty())) {
			/* empilha na lista de desfazer */
			this.pilhaTaticasUndo.push(currentAST);

			/* Atualiza a AST */
			currentAST = (this.pilhaTaticasRedo.pop());
			/* refazer realizado */
			return true;
		}
		else return false;
		
			/* refazer nao realizado */
			

	}

	/**
	 * Refaz Pilhas de Leis
	 *
	 */
	public void refazerPilhasLeis() {
		this.retornarPilhaDeLeis().push(retornarRedoPilhaDeLeis().pop());
		this.pilhas.getRespostaLeis().push(pilhas.getRedoRespostaLeis().pop());
	}

	/**
	 * Adiciona acao Coletada passada como  parametro
	 * @param newTerm Acao Coletada
	 */
	public void adicionarTermoColetado(TermoColetado newTerm) {
		this.pilhasP.getUndoAcoesColetadas().push(newTerm);
	}

	public void desfazerPilhaTermosColetados() {
		this.getRedoAcoesColetadas()
		.push(getUndoAcoesColetadas().pop());

	}

	public Markup getMarkUp() {
		return markUP;
	}

	public void setMarkUp(Markup mark) {
		markUP = mark;
	}

	public void desfazerRespostasLeis() {
		this.getRedoRespostasLeis().push(this.getRespostasLeis().pop());
	}

	public void desfazerPilhaDeLeis() {
		this.retornarRedoPilhaDeLeis().push(this.retornarPilhaDeLeis().pop());
	}
	public void refazerRespostasLeis() {
		this.getRespostasLeis().push(this.getRedoRespostasLeis().pop());

	}

	public void refazerPilhaDeLeis() {
		this.retornarPilhaDeLeis().push(this.retornarRedoPilhaDeLeis().pop());
	}

	public void refazerAcoesColetadas() {
		this.getUndoAcoesColetadas().
		push(this.getRedoAcoesColetadas().pop());

	}

	public void desfazerAcoesColetadas() {
		this.getRedoAcoesColetadas().
		push(this.getUndoAcoesColetadas().pop());

	}

	public void setNome(String string) {
		nome = string;
	}

	public Integer getChildAt(int childIndex) {
		return filhos.get(childIndex);
	}

	public int getChildrenCount() {
		return filhos.size();
	}

	public boolean isLeaf() {
		if (filhos.size() == 0) return true;
		return false;
	}

	/**
	 * 
	 * @param i indice do Filho a ser adicionado
	 */
	public void adicionarFilho(int i) {
		filhos.add(i);
	}

	public boolean hasChildren() {
		return  (getChildrenCount() > 0);
	}

	public void dcrFilhos() {
		for (int i=0; i< filhos.size();i++){
			filhos.set(i, filhos.get(i) -1);
		}
	}

	public void removendo() {
		beingRemoved = true;
	}
	public boolean estaSendoRemovido() {
		return beingRemoved;
	}

	public void adicionarFilhoOculto(PODevelopmentTree dev) {
		this.filhosOcultos.add(dev);
	}

	public void removerFilho(int tabNumber) {
		for (int i=0;i< filhos.size();i++){
			if (filhos.get(i) == tabNumber){
				filhos.remove(i);
				break;
			}
		}
	}

	public PODevelopmentTree getFilhoOculto(int identificador, ObrigacaoProva opSelecionada) {

		for (int i=0; i < filhosOcultos.size();i++){
			PODevelopmentTree filho = (PODevelopmentTree)filhosOcultos.get(i);
			if (filho.getIdxOp() == identificador){
				return filho;
			}
		}
		return null;
	}


	public PODevelopmentTree getFilhoOculto(int index) {

		return filhosOcultos.get(index);
	}


	public boolean hasHiddenChild() {
		if (filhosOcultos.size() >0) return true;
		return false;
	}

	public int getHiddenChildrenCount() {
		return filhosOcultos.size();
	}

	/**
	 * Decrementa o filho cujo indice � j.
	 * @param j
	 */
	public void dcrFilhos(int j) {
		for (int i=0; i < filhos.size();i++){
			if (filhos.get(i) == j){
				filhos.set(i, filhos.get(i) -1);
			}
		}
	}

	public Term getPenultimoProg() {
		return undoStack.peek();
	}

	public LinkedList<Integer> getFilhos() {
		return filhos;
	}

	/**
	 * Para as táticas
	 * @return
	 */

	public Stack<TacticAnswer> getRespostasTaticas(){
		return pilhas.getTaticasApl();
	}

}	
