package circusRefine.core.crules.utils;

import java.util.Arrays;
import java.util.ListIterator;

import circusRefine.core.crules.factories.LawType;

/**
 * Classe que realiza a montagem da arvore de tipos de leis.
 * Mantendo a estrutura que devera ser utilizada para classificacao
 * de leis
 * @author alessandro87
 *
 */
public class TypeLawsTree {
	
	NodeTypeLaws raiz;
	
	public TypeLawsTree(){
		raiz = montarArvore();
	}
	
	/**
	 * Metodo que gera a classificacao de tipos, engrupando
	 * tipos e subtipos como uma arvore onde cada no representa
	 * um tipo com o enumeration LawType
	 * @return
	 */
	private NodeTypeLaws montarArvore() {
		NodeTypeLaws root = new NodeTypeLaws(null);

		/* Pega os tipos no qual vai iterar */
		ListIterator<LawType> iterador = 
				Arrays.asList(LawType.values()).listIterator();
		
		/* Percorre os tipos para construir a arvore */
		while (iterador.hasNext()) {
			root.adicionandoFilho(this.montarSubArvore(iterador.next(), 
					iterador));
		}
		
		return root;
	}
	
	/**
	 * Monta uma subrvore da lista de tipos 
	 * 
	 * @param pai a raiz da subrvore
	 * @param iterador o iterador sobre a lista de tipos
	 * @return a rvore montada
	 */
	private NodeTypeLaws montarSubArvore(LawType pai, 
			ListIterator<LawType> iterador) {
		
		/* Resultado */
		NodeTypeLaws result = new NodeTypeLaws(pai);
		
		if (pai.temFilhos()) {
			
			/* O pai tem filhos */
			boolean condicao = iterador.hasNext();
			while (condicao) {
				LawType filho = iterador.next();
				
				if (filho.eFilhoDe(pai)) {
					
					/* Adiciona a subrvore correspondente ao filho */ 
					result.adicionandoFilho(this.montarSubArvore(filho, 
							iterador));
					condicao = iterador.hasNext();
				} else {
					
					/* Volta um passo na lista corresponte */
					iterador.previous();
					condicao = false;
				}
			}
		}
		
		return result;
	}
	
	
	
	public NodeTypeLaws getRaiz() {
		return raiz;
	}
}
