package circusRefine.core.crules.utils;

import java.util.Arrays;
import java.util.LinkedList;

import circusRefine.core.print.Printer;
import circusRefine.core.util.ClonerVisitor;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.base.visitor.VisitorUtils;
import net.sourceforge.czt.circuspatt.impl.CircusPatternFactoryImpl;
import net.sourceforge.czt.z.ast.And;
import net.sourceforge.czt.z.ast.AndPred;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.ExprPred;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.QntPred;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.visitor.AndPredVisitor;
import net.sourceforge.czt.z.visitor.ExprPredVisitor;
import net.sourceforge.czt.z.visitor.MemPredVisitor;
import net.sourceforge.czt.z.visitor.PredVisitor;
import net.sourceforge.czt.z.visitor.QntPredVisitor;

/**
 * Esse visitor foi criado para capturar as restrições de uma dado
 * conjunto de declaração em uma estrutura de predicados
 * @author Alessandro
 *
 */
public class RestrictionsGetter implements TermVisitor<Void>,
MemPredVisitor<Void>,
ExprPredVisitor<Void>,
QntPredVisitor<Void>{

	private LinkedList<Pred> restricoes;
	private LinkedList<String> txtDeclaracoes;

	private RestrictionsGetter(ZDeclList decls){
		restricoes = new LinkedList<Pred>();
		txtDeclaracoes = new LinkedList<String>();

		for (Decl decl : decls) {
			if(decl instanceof VarDecl){
				for (Name a : ((VarDecl)decl).getZNameList()){
					txtDeclaracoes.add(((ZName)a).getWord());
				}
			}
			
		}
	}
	
	public static Pred getRestriction(ZDeclList list, Pred pred) {
		RestrictionsGetter getter = new RestrictionsGetter(list);
		pred.accept(getter);
		return getter.comporSolucao();
	}

	public Void visitTerm(Term termo) {
		VisitorUtils.visitTerm(this, termo);
		return null;
	}





	private Pred comporSolucao() {

		CircusPatternFactoryImpl factory = new CircusPatternFactoryImpl();

		if (restricoes.size() == 1){
			return restricoes.getFirst();
		}
		else if (restricoes.size() ==0){
			return factory.createTruePred();
		}

		Pred pred = restricoes.getFirst();
		for (int i=1; i< restricoes.size();i++){
			pred = factory.createAndPred(Arrays.asList(pred, restricoes.get(i)),
					And.Wedge);
		}


		return pred;
	}

	public Void visitMemPred(MemPred termo) {
		String txt = Printer.printLATTEX(termo);
		for (String decl : txtDeclaracoes) {
			if (txt.contains(decl)){
				restricoes.add(termo);
				return null;
			}
		}
		return null;
	}

	public Void visitExprPred(ExprPred termo) {
		String txt = Printer.printLATTEX(termo);
		for (String decl : txtDeclaracoes) {
			if (txt.contains(decl)){
				restricoes.add(termo);
				return null;
			}
		}
		return null;
	}

	public Void visitQntPred(QntPred termo) {
		String txt = Printer.printLATTEX(termo);
		for (String decl : txtDeclaracoes) {
			if (txt.contains(decl)){
				restricoes.add(termo);
				return null;
			}
		}
		return null;
	}
}
