package circusRefine.core.crules.utils;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.circus.visitor.ProcessParaVisitor;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.visitor.ParaVisitor;

public class ProcessOfANameGetter extends DefinitionFromATermGetter 
implements ParaVisitor<Void>, ProcessParaVisitor<Void> {

	/**
	 * Constri o objeto informando
	 * 
	 * @param nome o nome a ser pesquisado
	 * @param tipoNome a classe que representa o nome a ser 
	 *  pesquisado
	 */
	public ProcessOfANameGetter(ZName nome, Term tipoNome) {
		super(nome, tipoNome);
	}
	
	/**
	 * Visita um pargrafo genrico. No ir encontrar a definio do
	 * processo.
	 * 
	 * @param arg0 o pargrafo genrico a ser visitado
	 */
	public Void visitPara(Para arg0) {
		return null;
	}

	/**
	 * Testa se o nome do processo bate com o nome pesquisado. Caso 
	 * positivo, seta a definio 
	 */
	public Void visitProcessPara(ProcessPara arg0) {
		String strAPesquisar = this.getNomeAPesquisar().getWord();
		
		/* Testa se o nome  o mesmo do pesquisado */
		if (arg0.getZName().getWord().equals(strAPesquisar)) {
			
			/* Achou a definio do processo */
			this.setDefinition(arg0.getCircusProcess());
		}
		return null;
	}

}
