package circusRefine.core.crules.utils;

import java.util.List;

import net.sourceforge.czt.circuspatt.util.CircusLaw;
import circusRefine.core.ExternalManager;

/**
 * Esta classe contem o metodo que retorna a hierarquia da arvore de leis
 * @author alessandro87
 *
 */
public class HierarchyLawsTree {

	private ExternalManager gerInterface; /* necessario para a intercionalizacao*/
	private CodNameLaws table; //Tabela contendo nomes dos tipos de lei;
	private NodeHierarchyLaws raiz; // guarda a raiz da arvore;
	private List<CircusLaw> leis;
	int count;


	public HierarchyLawsTree(ExternalManager gerExterno, List<CircusLaw> laws) {
		super();
		this.gerInterface = gerExterno;
		this.leis = laws;
		table = new CodNameLaws(gerInterface.getInternacional(), gerExterno.getGerInterno());
		count = 0;
		montarArvore();

	}

	/**
	 * Metodo que constroi a arvore de hierarquia de leis.
	 * leis possuem list ade filhos = null
	 * tipo de leis possuem uma lista de filhos 
	 * Motagem Top - Down
	 */
	private void montarArvore() {

		raiz = new NodeHierarchyLaws(this.retornarMessagem("COD0015"));

		/*Inserindo Tipos de Lei*/

		TypeLawsTree tipoTree = new TypeLawsTree();
		NodeTypeLaws raizTipo  = tipoTree.getRaiz();
		adicionandoTipos(raiz,raizTipo);

		/*Inserindo Leis*/
		for (CircusLaw lei : leis){
			String nome = lei.getName();
			String nomeTipo = table.getNameLawType(LawTypeAnnUtils.getAnnLawType(lei));

//			System.out.println("----");
//			System.out.println(nomeTipo);
//			System.out.println(nome);
//			System.out.println("@@@@");

			/*Verificando em que tipo de lei essa lei devera ser inserida*/
			obterNodoHierarchyLaw(nomeTipo, raiz, nome);
		}


	}

	public void obterNodoHierarchyLaw(String nomeTipo, NodeHierarchyLaws nodo, String nome) {

		if (nomeTipo.equals(nodo.getName())) {
			NodeHierarchyLaws novoFilhoLei = new NodeHierarchyLaws(nome);
			nodo.adicionandoFilho(novoFilhoLei);
		}
		else {
			if (nodo.getFilhos() != null) {
				for (NodeHierarchyLaws nodoFilho : nodo.getFilhos()) {
					obterNodoHierarchyLaw(nomeTipo, nodoFilho, nome);
				}
			}
		}
	}

	private void adicionandoTipos(NodeHierarchyLaws nodo, NodeTypeLaws nodoTipo) {

		for (NodeTypeLaws tipo : nodoTipo.getFilhos()){
			NodeHierarchyLaws novoFilho = new NodeHierarchyLaws(table.getNameLawType(tipo.getTipo()));
			novoFilho.habilitandoFilhos();
			nodo.adicionandoFilho(novoFilho);
			adicionandoTipos(novoFilho, tipo);
		}
	}

	private String retornarMessagem(String cod) {
		return this.gerInterface.getMessage(cod);
	}

	public NodeHierarchyLaws getRaiz() {
		return raiz;
	}


}
