package circusRefine.core.crules.utils;

import java.util.LinkedList;

import circusRefine.core.print.Printer;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.base.visitor.VisitorUtils;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.InputField;
import net.sourceforge.czt.circus.visitor.InputFieldVisitor;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.visitor.DeclVisitor;
import net.sourceforge.czt.z.visitor.RefExprVisitor;


/**
 * Esse visitor procura numa dada ação, as ocorrências livres 
 * de uma expressão. Utilizado na Lei C.83
 * @author alessandro
 *
 */
public class FreeOccurrencesExprFromActionGetter 
implements 
TermVisitor<Void>,
RefExprVisitor<Void>,
DeclVisitor<Void>,
InputFieldVisitor<Void>
{

	private boolean visitandoBloco;
	private Expr itemDeProcura;
	private LinkedList<Expr> ocorrencias;
	
	public FreeOccurrencesExprFromActionGetter(Expr e) {
		this.itemDeProcura = e;
		visitandoBloco = false;
		this.ocorrencias = new LinkedList<Expr>();
	}

	public static LinkedList<Expr> procurarOcorrencias(CircusAction a, Expr e) {
		FreeOccurrencesExprFromActionGetter res = new FreeOccurrencesExprFromActionGetter(e);
		a.accept(res);
		return res.getOcorrencias();
		
	}

	public Void visitTerm(Term arg0) {
		VisitorUtils.visitTerm(this, arg0);
		return null;
	}

	public Void visitRefExpr(RefExpr arg0) {
		if (!visitandoBloco) {
			String expr1txt = Printer.printLATTEX(arg0);
			String expr2txt = Printer.printLATTEX(this.itemDeProcura);
			if (expr1txt.equals(expr2txt)){
				this.ocorrencias.add(arg0);
			}
		}
		return null;
		
	}

	public Void visitDecl(Decl arg0) {
		
		this.visitandoBloco = true;
		VisitorUtils.visitTerm(this, arg0);
		this.visitandoBloco = false;
		
		return null;
	}

	public LinkedList<Expr> getOcorrencias() {
		return ocorrencias;
	}

	public Void visitInputField(InputField arg0) {
		
		this.visitandoBloco = true;
		VisitorUtils.visitTerm(this, arg0);
		this.visitandoBloco = false;
		
		return null;
	}

}
