package circusRefine.core.crules.utils;



import circusRefine.core.annotations.TemporaryTermAnn;
import circusRefine.core.crules.UpdateVisitor;
import circusRefine.core.print.Printer;
import circusRefine.core.util.ClonerVisitor;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.base.visitor.VisitorUtils;
import net.sourceforge.czt.circus.util.CircusString;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circuspatt.impl.CircusPatternFactoryImpl;
import net.sourceforge.czt.z.ast.NextStroke;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.Stroke;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.z.visitor.RefExprVisitor;
import net.sourceforge.czt.z.visitor.ZNameVisitor;

/**
 * Diante de um termo p, calcula e retorna p'
 * @author alessandro87
 *
 */
public class DashedTerm implements TermVisitor<Term>, ZNameVisitor<Term>
{

	private Term dashedTerm;

	public Term getDTerm() {
		return dashedTerm;
	}
	public DashedTerm(Term termo) {
		dashedTerm = ClonerVisitor.cloneTerm(termo);
	}
	
	public static Term getDashedTerm (Term termo) {
		DashedTerm visitor = new DashedTerm(termo);
		visitor.visitTerm(visitor.getDTerm());
		return visitor.getDTerm();
	}
	
	public Term visitTerm(Term termo) {
		VisitorUtils.visitTerm(this, termo);
		return dashedTerm;
	}

	public Term visitZName(ZName term) {
		String str = Printer.printLATTEX(term);
		
		if (str.equals(ZString.ARITHMOS)) {
		}
		else if(str.equals(ZString.NAT)) {
		}
		else if  (str.startsWith(ZString.XI)) {
		}
		else if (str.equals(ZString.EMPTYSET)) {
		}
		else if (str.equals(CircusString.BOOLEAN)) {
		}
		else if (str.equals(ZString.NAT + ZString.ARG_TOK + 1 )) {
		}
		else if  (str.equals(ZString.NUM)) {
		}
		else if(str.equals("#"+ZString.ARG_TOK)) {
		}
		else if(str.equals(ZString.FINSET + ZString.ARG_TOK)) {
		}
		else if(str.equals(ZString.MINUS + ZString.ARG_TOK)) {
		}
		else if(str.equals("min" + ZString.ARG_TOK)) {
		}
		else if(str.equals("seq" + ZString.ARG_TOK)) {
		}
		else if (str.startsWith(ZString.DELTA)) {
		}
		else if(str.equals("iseq" + ZString.ARG_TOK)) {
		}
		else if(str.equals("succ" + ZString.ARG_TOK)) {
		}
		else if (str.equals("\\alpha")) {
		}
		else if(str.equals(ZString.ARG_TOK + ZString.PLUS + ZString.ARG_TOK)) {
		}
		else if(str.equals(ZString.ARG_TOK + ZString.MINUS + ZString.ARG_TOK)) {
		}
		else if(str.equals(ZString.ARG_TOK + ZString.LEQ + ZString.ARG_TOK)) {
		}
		else if(str.equals(ZString.ARG_TOK + ZString.GEQ + ZString.ARG_TOK)) {
		}
		else if(str.equals(ZString.ARG_TOK + ZString.GREATER + ZString.ARG_TOK)) {
		}
		else if(str.equals(ZString.ARG_TOK + ZString.LESS + ZString.ARG_TOK)) {
		}
		else if(str.equals(ZString.ARG_TOK + ZString.FUN + ZString.ARG_TOK)) {
		}
		else if(str.equals(ZString.ARG_TOK + ZString.PFUN + ZString.ARG_TOK)) {
		}
		else if(str.equals(ZString.ARG_TOK + ZString.CAP + ZString.ARG_TOK)) {
		}
		else if(str.equals(ZString.ARG_TOK + ZString.PINJ + ZString.ARG_TOK)) {
		}
		else if(str.equals(ZString.ARG_TOK + ZString.INJ + ZString.ARG_TOK)) {
		}
		else if(str.equals(ZString.ARG_TOK + ZString.PSURJ + ZString.ARG_TOK)) {
		}
		else if(str.equals(ZString.ARG_TOK + ZString.SURJ + ZString.ARG_TOK)) {
		}
		else if(str.equals(ZString.ARG_TOK + ZString.BIJ + ZString.ARG_TOK)) {
		}
		else if(str.equals(ZString.ARG_TOK + ZString.FFUN + ZString.ARG_TOK)) {
		}
		else if(str.equals(ZString.ARG_TOK + ZString.FINJ + ZString.ARG_TOK)) {
		}
		else if(str.equals(ZString.ARG_TOK + ZString.REL + ZString.ARG_TOK)) {
		}
		else if (str.equals(ZString.LANGLE + " " + ZString.COMMA + ZString.COMMA + " " + ZString.RANGLE)){
		}
		else if (str.equals(CircusUtils.DEFAULT_MAIN_ACTION_NAME)){
		}
		else {/* É um identificador de variável*/
			
			CircusPatternFactoryImpl factory = new CircusPatternFactoryImpl();
			boolean hasStroke = false;
			for (Stroke s : term.getZStrokeList()){
				if (s instanceof NextStroke) {
					hasStroke = true;
				}
			}
			if (!hasStroke){
				term.getZStrokeList().add(factory.createNextStroke());
				ZName novoNome = factory.createZName(term.getWord(), term.getZStrokeList(), null);
				dashedTerm = (Term)UpdateVisitor.update(term, novoNome,dashedTerm,false);
			}
			
		}
		
		
		return null;
	}




}
