/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.utils;

import java.util.List;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import circusRefine.core.util.ChildrenTermExtractor;


/**
 * Classe que verifica se um termo pertence a uma rvore.
 * 
 * @author Cristiano Gurgel
 */ 
public class ContainsTermTester implements TermVisitor<Boolean> {
	
	public static boolean containsTerm(Term toTest, Term ast) {
		ContainsTermTester visitor = new ContainsTermTester(toTest);
		return ast.accept(visitor);
	}
	
	private Term aProcurar;
	
	public ContainsTermTester(Term toLookFor) {
		this.setAProcurar(toLookFor);
	}
	
	public Term getAProcurar() {
		return aProcurar;
	}
	
	public void setAProcurar(Term procurar) {
		aProcurar = procurar;
	}
	
	/**
	 * Efetua uma busca para ver se o termo a procurar pertence a
	 * rvore.
	 * 
	 * @param arg0 a rvore
	 * @return <code>true</code> caso o termo pertena a rvore
	 * 	ou <code>false</code> caso contrrio.
	 */
	public Boolean visitTerm(Term arg0) {
		
		/* Encontrou!!! */
		if (arg0.equals(this.getAProcurar())) {
			return true;
		} else {
			List<Term> filhos = ChildrenTermExtractor.extrairFilhos(arg0);
			
			/* Busca nos fillhos */
			for (Term filho : filhos) {
				if (filho.accept(this)) { /* Encontrou termo na rvore */
					return true;
				}
			}
			
			return false;
		}
	}
}
