package circusRefine.core.crules.utils;

import circusRefine.core.print.Printer;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.base.visitor.VisitorUtils;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.MuAction;
import net.sourceforge.czt.circus.visitor.MuActionVisitor;
import net.sourceforge.czt.z.ast.ZName;


/**
 * Visitor que verifica se um termo podera 
 * 
 * @author alessandro87
 *
 */
public class CheckRecursitivity 
implements
TermVisitor<Void>,
MuActionVisitor<Void>{

	private ZName x;
	/*auxiliar*/
	private CircusAction acaoVisitada;

	boolean result = false;
	
	/* Representa a acao que contem a recursao com o dado nome */
	private MuAction uXfX;

	public CheckRecursitivity(ZName X) {
		super();
		this.x = X;
		uXfX = null;
	}

	public Void visitTerm(Term arg0) {
		VisitorUtils.visitTerm(this, arg0);
		return null;
	}

	public Void visitMuAction(MuAction arg0) {
		
		if (arg0.getZName().getWord().equals(x.getWord())){
			if (acaoVisitada != null){
				if (!acaoVisitada.equals(arg0.getCircusAction())){
					String str1 = Printer.printLATTEX(acaoVisitada);
					String str2 = Printer.printLATTEX(arg0.getCircusAction());
					if (!str1.equals(str2)){
						result = false;
						uXfX = null;
					}
				}
			}
			else {
				acaoVisitada = arg0.getCircusAction();
				result = true;
				uXfX = arg0;
			}
		}
		return null;
	}
	/**
	 * 
	 * @return verdadeiro caso as referencias dos pontos de recursao
	 * sejam verdadeiros
	 */
	public boolean getAnswer() {
		return result;
	}
	
	public static boolean checkRecursitivity(ZName x, CircusAction acao) {
		CheckRecursitivity visitor = new CheckRecursitivity(x);
		acao.accept(visitor);
		return visitor.getAnswer();
	}
	
	public static MuAction getRecursitivityAction(ZName x, CircusAction acao) {
		CheckRecursitivity visitor = new CheckRecursitivity(x);
		acao.accept(visitor);
		return visitor.getUXfX();
	}

	public MuAction getUXfX() {
		return uXfX;
	}
}
