/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.utils;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.ChannelSet;
import net.sourceforge.czt.circus.ast.ChannelSetPara;
import net.sourceforge.czt.circus.visitor.ChannelSetParaVisitor;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.visitor.ParaVisitor;

/**
 * Classe utilizada para procurar a definio de um {@link ChannelSet}
 * em um refinamento
 * 
 * @author crisgc
 *
 */
public class ChannelSetFromATermGetter extends DefinitionFromATermGetter 
implements ParaVisitor<Void>, ChannelSetParaVisitor<Void> {

	/**
	 * Inicia o visitor com o nome a ser pesquisado
	 * 
	 * @param nome o nome a ser pesquisado
	 */
	public ChannelSetFromATermGetter(ZName nome, Term tipoNome) {
		super(nome, tipoNome);
	}

	/**
	 * No faz nada ao visitar um pargrafo qualquer. J que um 
	 * {@link ChannelSet} no pode ser definido em um pargrafo que 
	 * no seja um {@link ChannelSetPara}.
	 * 
	 * @param arg0 o pargrafo a ser visitado
	 */
	public Void visitPara(Para arg0) {
		return null;
	}

	/**
	 * 
	 */
	public Void visitChannelSetPara(ChannelSetPara arg0) {
		
		/* Compara o nome do conjunto de canais */
		if (arg0.getName().equals(this.getNomeAPesquisar())) {
			
			/* Achou a definio do channelSet */
			this.setDefinition(arg0.getChannelSet());
		}
		return null;
	}
	
	
}
