/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.testeRules;

import circusRefine.core.InternalManager;
import circusRefine.core.crules.UpdateVisitor;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.rules.UnboundJokerException;
import net.sourceforge.czt.rules.rewriter.RewriteUtils;
import net.sourceforge.czt.session.CommandException;
import net.sourceforge.czt.z.ast.Expr;

/**
 * Testa a aplicao de uma normalizao a um esquema
 * 
 * @author crisgc
 */
public class RuleApplier {

	public static Term applyNormalization( String nomeEsquema , 
			Term spec ) {
		
		/* SchEpr Expression in which the rule is going to be applied */
		Expr expression = ProcurarDefEsquema.getExprFromAName(nomeEsquema, 
				spec);
		
		/* Result of the rewrite operation */
		Term resultRewrite = null;
		
		Expr aSubstituir = RewriteUtils.createNormalizeAppl(expression);
		
		try {
			resultRewrite = RewriteUtils.rewrite(aSubstituir, 
					InternalManager.getManager(), "expansion_rules");
		} catch (CommandException e) {
			e.printStackTrace();
		} catch (UnboundJokerException e) {
			e.printStackTrace();
		}
		
		/* Update the AST */
		Term novaSpec = UpdateVisitor.update(expression, resultRewrite, spec,false);
		
		return novaSpec;
	}
	
}
