/*
 * Projeto: Circus Refine
 * 
 * Autor: Cristiano Gurgel de Castro
 */
package circusRefine.core.crules.testeRules;

import java.util.List;

import circusRefine.core.util.ChildrenTermExtractor;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.util.UnsupportedAstClassException;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.z.ast.ConstDecl;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.visitor.ConstDeclVisitor;

/**
 * Classe para procurar a definio de um esquema. 
 * 
 * @author Cristiano Gurgel
 */
public class ProcurarDefEsquema implements TermVisitor<Expr>, 
		ConstDeclVisitor<Expr> {

	/**
	 * 
	 * @param name
	 * @param spec
	 * @return
	 */
	public static Expr getExprFromAName( String name , Term spec ) {
		ProcurarDefEsquema visitor = new ProcurarDefEsquema( name );
		return spec.accept( visitor );
	}
	
	/** Nome da declarao a ser pesquisada */
	private String nomeDefinicao;
	
	public ProcurarDefEsquema(String nomeEsquema) {
		this.setNomeDefinicao(nomeEsquema);
	}

	public String getNomeDefinicao() {
		return nomeDefinicao;
	}
	
	public void setNomeDefinicao(String nomeDefinicao) {
		this.nomeDefinicao = nomeDefinicao;
	}
	
	/**
	 * 
	 */
	public Expr visitTerm(Term arg0) {
		List<Term> filhos = ChildrenTermExtractor.extrairFilhos(arg0);
		
		for ( Term filho : filhos ) {
			Expr result = filho.accept(this);
			if ( result != null ) {
				return result;
			}
		}
		return null;
	}

	/**
	 * 
	 */
	public Expr visitConstDecl(ConstDecl arg0) {
		try {
			if ( arg0.getZName().getWord().equals( this.getNomeDefinicao() ) ) {
				return arg0.getExpr();
			} else {
				return null;
			}
		} catch ( UnsupportedAstClassException e ) {
			return null;
		}
	}

}
