/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.crules.parseArgument;

import circusRefine.core.crules.CRulesException;
import circusRefine.core.crules.messages.CRulesMissingMessageException;
import circusRefine.core.crules.messages.MessagesManager;

/**
 * Excesso disparada quando h um erro no parse de argumentos 
 * passados pelo usurio.
 * 
 * @author Cristiano Castro
 *
 */
public class ParseArgumentException extends CRulesException {
	
	/** Nmero para a serializao */
	private static final long serialVersionUID = 3421617068255162037L;

	/**
	 * Inicia 
	 * 
	 * @throws CRulesMissingMessageException 
	 * 
	 */
	public ParseArgumentException() throws CRulesMissingMessageException {
		super(MessagesManager.getInstance().getMessage("COD0608"));
	}

	/**
	 * @param arg0
	 * @param arg1
	 * @throws CRulesMissingMessageException 
	 */
	public ParseArgumentException(String arg0, Throwable arg1) throws 
			CRulesMissingMessageException {
		super(MessagesManager.getInstance().getMessage(arg0), arg1);
	}

	/**
	 * @param arg0
	 * @throws CRulesMissingMessageException 
	 */
	public ParseArgumentException(String arg0) throws 
			CRulesMissingMessageException {
		super(MessagesManager.getInstance().getMessage(arg0));
		// TODO Auto-generated constructor stub
	}

	/**
	 * @param arg0
	 */
	public ParseArgumentException(Throwable arg0) {
		super(arg0);
		// TODO Auto-generated constructor stub
	}

}
